/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.factory.OFActionFactory;
import org.openflow.protocol.factory.OFActionFactoryAware;
import org.openflow.util.U16;

public class OFPacketOut
extends OFMessage
implements OFActionFactoryAware {
    public static int MINIMUM_LENGTH = 16;
    public static int BUFFER_ID_NONE = -1;
    protected OFActionFactory actionFactory;
    protected int bufferId;
    protected short inPort;
    protected short actionsLength;
    protected List<OFAction> actions;
    protected byte[] packetData;

    public OFPacketOut() {
        this.type = OFType.PACKET_OUT;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public OFPacketOut setBufferId(int bufferId) {
        this.bufferId = bufferId;
        return this;
    }

    public byte[] getPacketData() {
        return this.packetData;
    }

    public OFPacketOut setPacketData(byte[] packetData) {
        this.packetData = packetData;
        return this;
    }

    public short getInPort() {
        return this.inPort;
    }

    public OFPacketOut setInPort(short inPort) {
        this.inPort = inPort;
        return this;
    }

    public OFPacketOut setInPort(OFPort inPort) {
        this.inPort = inPort.getValue();
        return this;
    }

    public short getActionsLength() {
        return this.actionsLength;
    }

    public int getActionsLengthU() {
        return U16.f(this.actionsLength);
    }

    public OFPacketOut setActionsLength(short actionsLength) {
        this.actionsLength = actionsLength;
        return this;
    }

    public List<OFAction> getActions() {
        return this.actions;
    }

    public OFPacketOut setActions(List<OFAction> actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public void setActionFactory(OFActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.bufferId = data.getInt();
        this.inPort = data.getShort();
        this.actionsLength = data.getShort();
        if (this.actionFactory == null) {
            throw new RuntimeException("ActionFactory not set");
        }
        this.actions = this.actionFactory.parseActions(data, this.getActionsLengthU());
        this.packetData = new byte[this.getLengthU() - MINIMUM_LENGTH - this.getActionsLengthU()];
        data.get(this.packetData);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putInt(this.bufferId);
        data.putShort(this.inPort);
        data.putShort(this.actionsLength);
        for (OFAction action : this.actions) {
            action.writeTo(data);
        }
        if (this.packetData != null) {
            data.put(this.packetData);
        }
    }

    @Override
    public int hashCode() {
        int prime = 293;
        int result = super.hashCode();
        result = 293 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 293 * result + this.actionsLength;
        result = 293 * result + this.bufferId;
        result = 293 * result + this.inPort;
        result = 293 * result + Arrays.hashCode(this.packetData);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFPacketOut)) {
            return false;
        }
        OFPacketOut other = (OFPacketOut)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.actionsLength != other.actionsLength) {
            return false;
        }
        if (this.bufferId != other.bufferId) {
            return false;
        }
        if (this.inPort != other.inPort) {
            return false;
        }
        return Arrays.equals(this.packetData, other.packetData);
    }

    @Override
    public String toString() {
        return "OFPacketOut [actionFactory=" + this.actionFactory + ", actions=" + this.actions + ", actionsLength=" + this.actionsLength + ", bufferId=0x" + Integer.toHexString(this.bufferId) + ", inPort=" + this.inPort + ", packetData=" + Arrays.toString(this.packetData) + "]";
    }
}

