/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;
import org.openflow.util.U8;

public class OFPacketIn
extends OFMessage {
    public static int MINIMUM_LENGTH = 18;
    protected int bufferId;
    protected short totalLength;
    protected short inPort;
    protected OFPacketInReason reason;
    protected byte[] packetData;

    public OFPacketIn() {
        this.type = OFType.PACKET_IN;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public OFPacketIn setBufferId(int bufferId) {
        this.bufferId = bufferId;
        return this;
    }

    public byte[] getPacketData() {
        return this.packetData;
    }

    public OFPacketIn setPacketData(byte[] packetData) {
        this.packetData = packetData;
        this.length = U16.t(MINIMUM_LENGTH + packetData.length);
        return this;
    }

    public short getInPort() {
        return this.inPort;
    }

    public OFPacketIn setInPort(short inPort) {
        this.inPort = inPort;
        return this;
    }

    public OFPacketInReason getReason() {
        return this.reason;
    }

    public OFPacketIn setReason(OFPacketInReason reason) {
        this.reason = reason;
        return this;
    }

    public short getTotalLength() {
        return this.totalLength;
    }

    public OFPacketIn setTotalLength(short totalLength) {
        this.totalLength = totalLength;
        return this;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.bufferId = data.getInt();
        this.totalLength = data.getShort();
        this.inPort = data.getShort();
        this.reason = OFPacketInReason.values()[U8.f(data.get())];
        data.get();
        this.packetData = new byte[this.getLengthU() - MINIMUM_LENGTH];
        data.get(this.packetData);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putInt(this.bufferId);
        data.putShort(this.totalLength);
        data.putShort(this.inPort);
        data.put((byte)this.reason.ordinal());
        data.put((byte)0);
        data.put(this.packetData);
    }

    @Override
    public int hashCode() {
        int prime = 283;
        int result = super.hashCode();
        result = 283 * result + this.bufferId;
        result = 283 * result + this.inPort;
        result = 283 * result + Arrays.hashCode(this.packetData);
        result = 283 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 283 * result + this.totalLength;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFPacketIn)) {
            return false;
        }
        OFPacketIn other = (OFPacketIn)obj;
        if (this.bufferId != other.bufferId) {
            return false;
        }
        if (this.inPort != other.inPort) {
            return false;
        }
        if (!Arrays.equals(this.packetData, other.packetData)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return this.totalLength == other.totalLength;
    }

    public static enum OFPacketInReason {
        NO_MATCH,
        ACTION;

    }
}

