/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;
import org.openflow.util.U32;
import org.openflow.util.U8;

public class OFMessage
implements Serializable {
    public static byte OFP_VERSION = 1;
    public static int MINIMUM_LENGTH = 8;
    protected byte version = OFP_VERSION;
    protected OFType type;
    protected short length;
    protected int xid;

    public short getLength() {
        return this.length;
    }

    public int getLengthU() {
        return U16.f(this.length);
    }

    public OFMessage setLength(short length) {
        this.length = length;
        return this;
    }

    public OFMessage setLengthU(int length) {
        this.length = U16.t(length);
        return this;
    }

    public OFType getType() {
        return this.type;
    }

    public void setType(OFType type) {
        this.type = type;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public int getXid() {
        return this.xid;
    }

    public void setXid(int xid) {
        this.xid = xid;
    }

    public void readFrom(ByteBuffer data) {
        this.version = data.get();
        this.type = OFType.valueOf(data.get());
        this.length = data.getShort();
        this.xid = data.getInt();
    }

    public void writeTo(ByteBuffer data) {
        data.put(this.version);
        data.put(this.type.getTypeValue());
        data.putShort(this.length);
        data.putInt(this.xid);
    }

    public String toString() {
        return "ofmsg:v=" + U8.f(this.getVersion()) + ";t=" + (Object)((Object)this.getType()) + ";l=" + this.getLengthU() + ";x=" + U32.f(this.getXid());
    }

    public int hashCode() {
        int prime = 97;
        int result = 1;
        result = 97 * result + this.length;
        result = 97 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 97 * result + this.version;
        result = 97 * result + this.xid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFMessage)) {
            return false;
        }
        OFMessage other = (OFMessage)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return this.xid == other.xid;
    }
}

