/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFPort;
import org.openflow.util.HexString;
import org.openflow.util.U16;
import org.openflow.util.U8;

public class OFMatch
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int MINIMUM_LENGTH = 40;
    public static final int OFPFW_ALL = 0x3FFFFF;
    public static final int OFPFW_IN_PORT = 1;
    public static final int OFPFW_DL_VLAN = 2;
    public static final int OFPFW_DL_SRC = 4;
    public static final int OFPFW_DL_DST = 8;
    public static final int OFPFW_DL_TYPE = 16;
    public static final int OFPFW_NW_PROTO = 32;
    public static final int OFPFW_TP_SRC = 64;
    public static final int OFPFW_TP_DST = 128;
    public static final int OFPFW_NW_SRC_SHIFT = 8;
    public static final int OFPFW_NW_SRC_BITS = 6;
    public static final int OFPFW_NW_SRC_MASK = 16128;
    public static final int OFPFW_NW_SRC_ALL = 8192;
    public static final int OFPFW_NW_DST_SHIFT = 14;
    public static final int OFPFW_NW_DST_BITS = 6;
    public static final int OFPFW_NW_DST_MASK = 1032192;
    public static final int OFPFW_NW_DST_ALL = 524288;
    public static final int OFPFW_DL_VLAN_PCP = 0x100000;
    public static final int OFPFW_NW_TOS = 0x200000;
    public static final String STR_IN_PORT = "in_port";
    public static final String STR_DL_DST = "dl_dst";
    public static final String STR_DL_SRC = "dl_src";
    public static final String STR_DL_TYPE = "dl_type";
    public static final String STR_DL_VLAN = "dl_vlan";
    public static final String STR_DL_VLAN_PCP = "dl_vpcp";
    public static final String STR_NW_DST = "nw_dst";
    public static final String STR_NW_SRC = "nw_src";
    public static final String STR_NW_PROTO = "nw_proto";
    public static final String STR_NW_TOS = "nw_tos";
    public static final String STR_TP_DST = "tp_dst";
    public static final String STR_TP_SRC = "tp_src";
    protected int wildcards = 0x3FFFFF;
    protected short inputPort;
    protected byte[] dataLayerSource;
    protected byte[] dataLayerDestination = new byte[6];
    protected short dataLayerVirtualLan;
    protected byte dataLayerVirtualLanPriorityCodePoint;
    protected short dataLayerType;
    protected byte networkTypeOfService;
    protected byte networkProtocol;
    protected int networkSource;
    protected int networkDestination;
    protected short transportSource;
    protected short transportDestination;

    public OFMatch() {
        this.dataLayerSource = new byte[6];
    }

    public byte[] getDataLayerDestination() {
        return this.dataLayerDestination;
    }

    public OFMatch setDataLayerDestination(byte[] dataLayerDestination) {
        this.dataLayerDestination = dataLayerDestination;
        return this;
    }

    public OFMatch setDataLayerDestination(String mac) {
        byte[] bytes = HexString.fromHexString(mac);
        if (bytes.length != 6) {
            throw new IllegalArgumentException("expected string with 6 octets, got '" + mac + "'");
        }
        this.dataLayerDestination = bytes;
        return this;
    }

    public byte[] getDataLayerSource() {
        return this.dataLayerSource;
    }

    public OFMatch setDataLayerSource(byte[] dataLayerSource) {
        this.dataLayerSource = dataLayerSource;
        return this;
    }

    public OFMatch setDataLayerSource(String mac) {
        byte[] bytes = HexString.fromHexString(mac);
        if (bytes.length != 6) {
            throw new IllegalArgumentException("expected string with 6 octets, got '" + mac + "'");
        }
        this.dataLayerSource = bytes;
        return this;
    }

    public short getDataLayerType() {
        return this.dataLayerType;
    }

    public OFMatch setDataLayerType(short dataLayerType) {
        this.dataLayerType = dataLayerType;
        return this;
    }

    public short getDataLayerVirtualLan() {
        return this.dataLayerVirtualLan;
    }

    public OFMatch setDataLayerVirtualLan(short dataLayerVirtualLan) {
        this.dataLayerVirtualLan = dataLayerVirtualLan;
        return this;
    }

    public byte getDataLayerVirtualLanPriorityCodePoint() {
        return this.dataLayerVirtualLanPriorityCodePoint;
    }

    public OFMatch setDataLayerVirtualLanPriorityCodePoint(byte pcp) {
        this.dataLayerVirtualLanPriorityCodePoint = pcp;
        return this;
    }

    public short getInputPort() {
        return this.inputPort;
    }

    public OFMatch setInputPort(short inputPort) {
        this.inputPort = inputPort;
        return this;
    }

    public int getNetworkDestination() {
        return this.networkDestination;
    }

    public OFMatch setNetworkDestination(int networkDestination) {
        this.networkDestination = networkDestination;
        return this;
    }

    public int getNetworkDestinationMaskLen() {
        return Math.max(32 - ((this.wildcards & 0xFC000) >> 14), 0);
    }

    public int getNetworkSourceMaskLen() {
        return Math.max(32 - ((this.wildcards & 0x3F00) >> 8), 0);
    }

    public byte getNetworkProtocol() {
        return this.networkProtocol;
    }

    public OFMatch setNetworkProtocol(byte networkProtocol) {
        this.networkProtocol = networkProtocol;
        return this;
    }

    public int getNetworkSource() {
        return this.networkSource;
    }

    public OFMatch setNetworkSource(int networkSource) {
        this.networkSource = networkSource;
        return this;
    }

    public byte getNetworkTypeOfService() {
        return this.networkTypeOfService;
    }

    public OFMatch setNetworkTypeOfService(byte networkTypeOfService) {
        this.networkTypeOfService = networkTypeOfService;
        return this;
    }

    public short getTransportDestination() {
        return this.transportDestination;
    }

    public OFMatch setTransportDestination(short transportDestination) {
        this.transportDestination = transportDestination;
        return this;
    }

    public short getTransportSource() {
        return this.transportSource;
    }

    public OFMatch setTransportSource(short transportSource) {
        this.transportSource = transportSource;
        return this;
    }

    public int getWildcards() {
        return this.wildcards;
    }

    public OFMatch setWildcards(int wildcards) {
        this.wildcards = wildcards;
        return this;
    }

    public OFMatch loadFromPacket(byte[] packetData, short inputPort) {
        short scratch;
        int transportOffset = 34;
        ByteBuffer packetDataBB = ByteBuffer.wrap(packetData);
        int limit = packetDataBB.limit();
        this.wildcards = 0;
        this.inputPort = inputPort;
        if (inputPort == OFPort.OFPP_ALL.getValue()) {
            this.wildcards |= 1;
        }
        assert (limit >= 14);
        this.dataLayerDestination = new byte[6];
        packetDataBB.get(this.dataLayerDestination);
        this.dataLayerSource = new byte[6];
        packetDataBB.get(this.dataLayerSource);
        this.dataLayerType = packetDataBB.getShort();
        if (this.getDataLayerType() != -32512) {
            this.setDataLayerVirtualLan((short)-1);
            this.setDataLayerVirtualLanPriorityCodePoint((byte)0);
        } else {
            scratch = packetDataBB.getShort();
            this.setDataLayerVirtualLan((short)(0xFFF & scratch));
            this.setDataLayerVirtualLanPriorityCodePoint((byte)((0xE000 & scratch) >> 13));
            this.dataLayerType = packetDataBB.getShort();
        }
        switch (this.getDataLayerType()) {
            case 2048: {
                scratch = packetDataBB.get();
                scratch = (short)(0xF & scratch);
                transportOffset = packetDataBB.position() - 1 + scratch * 4;
                scratch = packetDataBB.get();
                this.setNetworkTypeOfService((byte)((0xFC & scratch) >> 2));
                packetDataBB.position(packetDataBB.position() + 7);
                this.networkProtocol = packetDataBB.get();
                packetDataBB.position(packetDataBB.position() + 2);
                this.networkSource = packetDataBB.getInt();
                this.networkDestination = packetDataBB.getInt();
                packetDataBB.position(transportOffset);
                break;
            }
            case 2054: {
                int arpPos = packetDataBB.position();
                scratch = packetDataBB.getShort(arpPos + 6);
                this.setNetworkProtocol((byte)(0xFF & scratch));
                scratch = packetDataBB.getShort(arpPos + 2);
                if (scratch == 2048 && packetDataBB.get(arpPos + 5) == 4) {
                    this.networkSource = packetDataBB.getInt(arpPos + 14);
                    this.networkDestination = packetDataBB.getInt(arpPos + 24);
                    break;
                }
                this.setNetworkSource(0);
                this.setNetworkDestination(0);
                break;
            }
            default: {
                this.setNetworkTypeOfService((byte)0);
                this.setNetworkProtocol((byte)0);
                this.setNetworkSource(0);
                this.setNetworkDestination(0);
            }
        }
        switch (this.getNetworkProtocol()) {
            case 1: {
                this.transportSource = U8.f(packetDataBB.get());
                this.transportDestination = U8.f(packetDataBB.get());
                break;
            }
            case 6: {
                this.transportSource = packetDataBB.getShort();
                this.transportDestination = packetDataBB.getShort();
                break;
            }
            case 17: {
                this.transportSource = packetDataBB.getShort();
                this.transportDestination = packetDataBB.getShort();
                break;
            }
            default: {
                this.setTransportDestination((short)0);
                this.setTransportSource((short)0);
            }
        }
        return this;
    }

    public void readFrom(ByteBuffer data) {
        this.wildcards = data.getInt();
        this.inputPort = data.getShort();
        this.dataLayerSource = new byte[6];
        data.get(this.dataLayerSource);
        this.dataLayerDestination = new byte[6];
        data.get(this.dataLayerDestination);
        this.dataLayerVirtualLan = data.getShort();
        this.dataLayerVirtualLanPriorityCodePoint = data.get();
        data.get();
        this.dataLayerType = data.getShort();
        this.networkTypeOfService = data.get();
        this.networkProtocol = data.get();
        data.get();
        data.get();
        this.networkSource = data.getInt();
        this.networkDestination = data.getInt();
        this.transportSource = data.getShort();
        this.transportDestination = data.getShort();
    }

    public void writeTo(ByteBuffer data) {
        data.putInt(this.wildcards);
        data.putShort(this.inputPort);
        data.put(this.dataLayerSource);
        data.put(this.dataLayerDestination);
        data.putShort(this.dataLayerVirtualLan);
        data.put(this.dataLayerVirtualLanPriorityCodePoint);
        data.put((byte)0);
        data.putShort(this.dataLayerType);
        data.put(this.networkTypeOfService);
        data.put(this.networkProtocol);
        data.put((byte)0);
        data.put((byte)0);
        data.putInt(this.networkSource);
        data.putInt(this.networkDestination);
        data.putShort(this.transportSource);
        data.putShort(this.transportDestination);
    }

    public int hashCode() {
        int prime = 131;
        int result = 1;
        result = 131 * result + Arrays.hashCode(this.dataLayerDestination);
        result = 131 * result + Arrays.hashCode(this.dataLayerSource);
        result = 131 * result + this.dataLayerType;
        result = 131 * result + this.dataLayerVirtualLan;
        result = 131 * result + this.dataLayerVirtualLanPriorityCodePoint;
        result = 131 * result + this.inputPort;
        result = 131 * result + this.networkDestination;
        result = 131 * result + this.networkProtocol;
        result = 131 * result + this.networkSource;
        result = 131 * result + this.networkTypeOfService;
        result = 131 * result + this.transportDestination;
        result = 131 * result + this.transportSource;
        result = 131 * result + this.wildcards;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFMatch)) {
            return false;
        }
        OFMatch other = (OFMatch)obj;
        if (!Arrays.equals(this.dataLayerDestination, other.dataLayerDestination)) {
            return false;
        }
        if (!Arrays.equals(this.dataLayerSource, other.dataLayerSource)) {
            return false;
        }
        if (this.dataLayerType != other.dataLayerType) {
            return false;
        }
        if (this.dataLayerVirtualLan != other.dataLayerVirtualLan) {
            return false;
        }
        if (this.dataLayerVirtualLanPriorityCodePoint != other.dataLayerVirtualLanPriorityCodePoint) {
            return false;
        }
        if (this.inputPort != other.inputPort) {
            return false;
        }
        if (this.networkDestination != other.networkDestination) {
            return false;
        }
        if (this.networkProtocol != other.networkProtocol) {
            return false;
        }
        if (this.networkSource != other.networkSource) {
            return false;
        }
        if (this.networkTypeOfService != other.networkTypeOfService) {
            return false;
        }
        if (this.transportDestination != other.transportDestination) {
            return false;
        }
        if (this.transportSource != other.transportSource) {
            return false;
        }
        return (this.wildcards & 0x3FFFFF) == (other.wildcards & 0x3FFFFF);
    }

    public OFMatch clone() {
        try {
            OFMatch ret = (OFMatch)super.clone();
            ret.dataLayerDestination = (byte[])this.dataLayerDestination.clone();
            ret.dataLayerSource = (byte[])this.dataLayerSource.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String str = "";
        if ((this.wildcards & 1) == 0) {
            str = str + ",in_port=" + U16.f(this.inputPort);
        }
        if ((this.wildcards & 8) == 0) {
            str = str + ",dl_dst=" + HexString.toHexString(this.dataLayerDestination);
        }
        if ((this.wildcards & 4) == 0) {
            str = str + ",dl_src=" + HexString.toHexString(this.dataLayerSource);
        }
        if ((this.wildcards & 0x10) == 0) {
            str = str + ",dl_type=0x" + Integer.toHexString(U16.f(this.dataLayerType));
        }
        if ((this.wildcards & 2) == 0) {
            str = str + ",dl_vlan=0x" + Integer.toHexString(U16.f(this.dataLayerVirtualLan));
        }
        if ((this.wildcards & 0x100000) == 0) {
            str = str + ",dl_vpcp=" + Integer.toHexString(U8.f(this.dataLayerVirtualLanPriorityCodePoint));
        }
        if (this.getNetworkDestinationMaskLen() > 0) {
            str = str + ",nw_dst=" + this.cidrToString(this.networkDestination, this.getNetworkDestinationMaskLen());
        }
        if (this.getNetworkSourceMaskLen() > 0) {
            str = str + ",nw_src=" + this.cidrToString(this.networkSource, this.getNetworkSourceMaskLen());
        }
        if ((this.wildcards & 0x20) == 0) {
            str = str + ",nw_proto=" + this.networkProtocol;
        }
        if ((this.wildcards & 0x200000) == 0) {
            str = str + ",nw_tos=" + this.networkTypeOfService;
        }
        if ((this.wildcards & 0x80) == 0) {
            str = str + ",tp_dst=" + this.transportDestination;
        }
        if ((this.wildcards & 0x40) == 0) {
            str = str + ",tp_src=" + this.transportSource;
        }
        if (str.length() > 0 && str.charAt(0) == ',') {
            str = str.substring(1);
        }
        return "OFMatch[" + str + "]";
    }

    private String cidrToString(int ip, int prefix) {
        String str;
        if (prefix >= 32) {
            str = OFMatch.ipToString(ip);
        } else {
            int mask = ~((1 << 32 - prefix) - 1);
            str = OFMatch.ipToString(ip & mask) + "/" + prefix;
        }
        return str;
    }

    public void fromString(String match) throws IllegalArgumentException {
        if (match.equals("") || match.equalsIgnoreCase("any") || match.equalsIgnoreCase("all") || match.equals("[]")) {
            match = "OFMatch[]";
        }
        String[] tokens = match.split("[\\[,\\]]");
        int initArg = 0;
        if (tokens[0].equals("OFMatch")) {
            initArg = 1;
        }
        this.wildcards = 0x3FFFFF;
        for (int i = initArg; i < tokens.length; ++i) {
            String[] values = tokens[i].split("=");
            if (values.length != 2) {
                throw new IllegalArgumentException("Token " + tokens[i] + " does not have form 'key=value' parsing " + match);
            }
            values[0] = values[0].toLowerCase();
            if (values[0].equals(STR_IN_PORT) || values[0].equals("input_port")) {
                this.inputPort = U16.t(Integer.valueOf(values[1]));
                this.wildcards &= 0xFFFFFFFE;
                continue;
            }
            if (values[0].equals(STR_DL_DST) || values[0].equals("eth_dst")) {
                this.dataLayerDestination = HexString.fromHexString(values[1]);
                this.wildcards &= 0xFFFFFFF7;
                continue;
            }
            if (values[0].equals(STR_DL_SRC) || values[0].equals("eth_src")) {
                this.dataLayerSource = HexString.fromHexString(values[1]);
                this.wildcards &= 0xFFFFFFFB;
                continue;
            }
            if (values[0].equals(STR_DL_TYPE) || values[0].equals("eth_type")) {
                this.dataLayerType = values[1].startsWith("0x") ? U16.t(Integer.valueOf(values[1].replaceFirst("0x", ""), 16)) : U16.t(Integer.valueOf(values[1]));
                this.wildcards &= 0xFFFFFFEF;
                continue;
            }
            if (values[0].equals(STR_DL_VLAN)) {
                this.dataLayerVirtualLan = U16.t(Integer.valueOf(values[1]));
                this.wildcards &= 0xFFFFFFFD;
                continue;
            }
            if (values[0].equals(STR_DL_VLAN_PCP)) {
                this.dataLayerVirtualLanPriorityCodePoint = U8.t(Short.valueOf(values[1]));
                this.wildcards &= 0xFFEFFFFF;
                continue;
            }
            if (values[0].equals(STR_NW_DST) || values[0].equals("ip_dst")) {
                this.setFromCIDR(values[1], STR_NW_DST);
                continue;
            }
            if (values[0].equals(STR_NW_SRC) || values[0].equals("ip_src")) {
                this.setFromCIDR(values[1], STR_NW_SRC);
                continue;
            }
            if (values[0].equals(STR_NW_PROTO)) {
                this.networkProtocol = U8.t(Short.valueOf(values[1]));
                this.wildcards &= 0xFFFFFFDF;
                continue;
            }
            if (values[0].equals(STR_NW_TOS)) {
                this.networkTypeOfService = U8.t(Short.valueOf(values[1]));
                this.wildcards &= 0xFFDFFFFF;
                continue;
            }
            if (values[0].equals(STR_TP_DST)) {
                this.transportDestination = U16.t(Integer.valueOf(values[1]));
                this.wildcards &= 0xFFFFFF7F;
                continue;
            }
            if (values[0].equals(STR_TP_SRC)) {
                this.transportSource = U16.t(Integer.valueOf(values[1]));
                this.wildcards &= 0xFFFFFFBF;
                continue;
            }
            throw new IllegalArgumentException("unknown token " + tokens[i] + " parsing " + match);
        }
    }

    private void setFromCIDR(String cidr, String which) throws IllegalArgumentException {
        String[] values = cidr.split("/");
        String[] ip_str = values[0].split("\\.");
        int ip = 0;
        ip += Integer.valueOf(ip_str[0]) << 24;
        ip += Integer.valueOf(ip_str[1]) << 16;
        ip += Integer.valueOf(ip_str[2]) << 8;
        ip += Integer.valueOf(ip_str[3]).intValue();
        int prefix = 32;
        if (values.length >= 2) {
            prefix = Integer.valueOf(values[1]);
        }
        int mask = 32 - prefix;
        if (which.equals(STR_NW_DST)) {
            this.networkDestination = ip;
            this.wildcards = this.wildcards & 0xFFF03FFF | mask << 14;
        } else if (which.equals(STR_NW_SRC)) {
            this.networkSource = ip;
            this.wildcards = this.wildcards & 0xFFFFC0FF | mask << 8;
        }
    }

    protected static String ipToString(int ip) {
        return Integer.toString(U8.f((byte)((ip & 0xFF000000) >> 24))) + "." + Integer.toString((ip & 0xFF0000) >> 16) + "." + Integer.toString((ip & 0xFF00) >> 8) + "." + Integer.toString(ip & 0xFF);
    }

    public OFMatch reverse(short inputPort, boolean wildcardInputPort) {
        OFMatch ret = this.clone();
        if (wildcardInputPort) {
            ret.inputPort = 0;
            ret.wildcards |= 1;
        } else {
            ret.inputPort = inputPort;
            ret.wildcards &= 0xFFFFFFFE;
        }
        ret.dataLayerDestination = (byte[])this.dataLayerSource.clone();
        ret.dataLayerSource = (byte[])this.dataLayerDestination.clone();
        ret.networkDestination = this.networkSource;
        ret.networkSource = this.networkDestination;
        ret.transportDestination = this.transportSource;
        ret.transportSource = this.transportDestination;
        ret.wildcards &= 0xFFF00033;
        ret.wildcards = ret.wildcards | ((this.wildcards & 8) != 0 ? 4 : 0);
        ret.wildcards = ret.wildcards | ((this.wildcards & 4) != 0 ? 8 : 0);
        ret.wildcards |= (this.wildcards & 0xFC000) >> 14 << 8;
        ret.wildcards |= (this.wildcards & 0x3F00) >> 8 << 14;
        ret.wildcards = ret.wildcards | ((this.wildcards & 0x80) != 0 ? 64 : 0);
        ret.wildcards = ret.wildcards | ((this.wildcards & 0x40) != 0 ? 128 : 0);
        return ret;
    }

    public boolean subsumes(OFMatch match) {
        int mask;
        if ((this.wildcards & 1) == 0 && this.inputPort != match.inputPort) {
            return false;
        }
        if ((this.wildcards & 8) == 0 && !Arrays.equals(this.dataLayerDestination, match.dataLayerDestination)) {
            return false;
        }
        if ((this.wildcards & 4) == 0 && !Arrays.equals(this.dataLayerSource, match.dataLayerSource)) {
            return false;
        }
        if ((this.wildcards & 0x10) == 0 && this.dataLayerType != match.dataLayerType) {
            return false;
        }
        if ((this.wildcards & 2) == 0 && this.dataLayerVirtualLan != match.dataLayerVirtualLan) {
            return false;
        }
        if ((this.wildcards & 0x100000) == 0 && this.dataLayerVirtualLanPriorityCodePoint != match.dataLayerVirtualLanPriorityCodePoint) {
            return false;
        }
        int maskLen = this.getNetworkDestinationMaskLen();
        if (maskLen > match.getNetworkDestinationMaskLen()) {
            return false;
        }
        int n = mask = maskLen == 0 ? 0 : -1 << 32 - maskLen;
        if ((this.networkDestination & mask) != (match.networkDestination & mask)) {
            return false;
        }
        maskLen = this.getNetworkSourceMaskLen();
        if (maskLen > match.getNetworkSourceMaskLen()) {
            return false;
        }
        int n2 = mask = maskLen == 0 ? 0 : -1 << 32 - maskLen;
        if ((this.networkSource & mask) != (match.networkSource & mask)) {
            return false;
        }
        if ((this.wildcards & 0x20) == 0 && this.networkProtocol != match.networkProtocol) {
            return false;
        }
        if ((this.wildcards & 0x200000) == 0 && this.networkTypeOfService != match.networkTypeOfService) {
            return false;
        }
        if ((this.wildcards & 0x80) == 0 && this.transportDestination != match.transportDestination) {
            return false;
        }
        return (this.wildcards & 0x40) != 0 || this.transportSource == match.transportSource;
    }
}

