/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFFlowRemoved
extends OFMessage {
    public static int MINIMUM_LENGTH = 88;
    protected OFMatch match;
    protected long cookie;
    protected short priority;
    protected OFFlowRemovedReason reason;
    protected int durationSeconds;
    protected int durationNanoseconds;
    protected short idleTimeout;
    protected long packetCount;
    protected long byteCount;

    public OFFlowRemoved() {
        this.type = OFType.FLOW_REMOVED;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public long getCookie() {
        return this.cookie;
    }

    public void setCookie(long cookie) {
        this.cookie = cookie;
    }

    public short getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public OFMatch getMatch() {
        return this.match;
    }

    public void setMatch(OFMatch match) {
        this.match = match;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public OFFlowRemovedReason getReason() {
        return this.reason;
    }

    public void setReason(OFFlowRemovedReason reason) {
        this.reason = reason;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public int getDurationNanoseconds() {
        return this.durationNanoseconds;
    }

    public void setDurationNanoseconds(int durationNanoseconds) {
        this.durationNanoseconds = durationNanoseconds;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public void setPacketCount(long packetCount) {
        this.packetCount = packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        if (this.match == null) {
            this.match = new OFMatch();
        }
        this.match.readFrom(data);
        this.cookie = data.getLong();
        this.priority = data.getShort();
        this.reason = OFFlowRemovedReason.values()[0xFF & data.get()];
        data.get();
        this.durationSeconds = data.getInt();
        this.durationNanoseconds = data.getInt();
        this.idleTimeout = data.getShort();
        data.get();
        data.get();
        this.packetCount = data.getLong();
        this.byteCount = data.getLong();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        this.match.writeTo(data);
        data.putLong(this.cookie);
        data.putShort(this.priority);
        data.put((byte)this.reason.ordinal());
        data.put((byte)0);
        data.putInt(this.durationSeconds);
        data.putInt(this.durationNanoseconds);
        data.putShort(this.idleTimeout);
        data.put((byte)0);
        data.put((byte)0);
        data.putLong(this.packetCount);
        data.putLong(this.byteCount);
    }

    @Override
    public int hashCode() {
        int prime = 271;
        int result = super.hashCode();
        result = 271 * result + (int)(this.byteCount ^ this.byteCount >>> 32);
        result = 271 * result + (int)(this.cookie ^ this.cookie >>> 32);
        result = 271 * result + this.durationNanoseconds;
        result = 271 * result + this.durationSeconds;
        result = 271 * result + this.idleTimeout;
        result = 271 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 271 * result + (int)(this.packetCount ^ this.packetCount >>> 32);
        result = 271 * result + this.priority;
        result = 271 * result + (this.reason == null ? 0 : this.reason.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFFlowRemoved)) {
            return false;
        }
        OFFlowRemoved other = (OFFlowRemoved)obj;
        if (this.byteCount != other.byteCount) {
            return false;
        }
        if (this.cookie != other.cookie) {
            return false;
        }
        if (this.durationNanoseconds != other.durationNanoseconds) {
            return false;
        }
        if (this.durationSeconds != other.durationSeconds) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.packetCount != other.packetCount) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason));
    }

    public static enum OFFlowRemovedReason {
        OFPRR_IDLE_TIMEOUT,
        OFPRR_HARD_TIMEOUT,
        OFPRR_DELETE;

    }
}

