/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.factory.OFActionFactory;
import org.openflow.protocol.factory.OFActionFactoryAware;
import org.openflow.util.U16;

public class OFFlowMod
extends OFMessage
implements OFActionFactoryAware,
Cloneable {
    public static int MINIMUM_LENGTH = 72;
    public static final short OFPFC_ADD = 0;
    public static final short OFPFC_MODIFY = 1;
    public static final short OFPFC_MODIFY_STRICT = 2;
    public static final short OFPFC_DELETE = 3;
    public static final short OFPFC_DELETE_STRICT = 4;
    protected OFActionFactory actionFactory;
    protected OFMatch match;
    protected long cookie;
    protected short command;
    protected short idleTimeout;
    protected short hardTimeout;
    protected short priority;
    protected int bufferId;
    protected short outPort;
    protected short flags;
    protected List<OFAction> actions;

    public OFFlowMod() {
        this.type = OFType.FLOW_MOD;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public OFFlowMod setBufferId(int bufferId) {
        this.bufferId = bufferId;
        return this;
    }

    public long getCookie() {
        return this.cookie;
    }

    public OFFlowMod setCookie(long cookie) {
        this.cookie = cookie;
        return this;
    }

    public short getCommand() {
        return this.command;
    }

    public OFFlowMod setCommand(short command) {
        this.command = command;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public OFFlowMod setFlags(short flags) {
        this.flags = flags;
        return this;
    }

    public short getHardTimeout() {
        return this.hardTimeout;
    }

    public OFFlowMod setHardTimeout(short hardTimeout) {
        this.hardTimeout = hardTimeout;
        return this;
    }

    public short getIdleTimeout() {
        return this.idleTimeout;
    }

    public OFFlowMod setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public OFMatch getMatch() {
        return this.match;
    }

    public OFFlowMod setMatch(OFMatch match) {
        this.match = match;
        return this;
    }

    public short getOutPort() {
        return this.outPort;
    }

    public OFFlowMod setOutPort(short outPort) {
        this.outPort = outPort;
        return this;
    }

    public OFFlowMod setOutPort(OFPort port) {
        this.outPort = port.getValue();
        return this;
    }

    public short getPriority() {
        return this.priority;
    }

    public OFFlowMod setPriority(short priority) {
        this.priority = priority;
        return this;
    }

    public List<OFAction> getActions() {
        return this.actions;
    }

    public OFFlowMod setActions(List<OFAction> actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        if (this.match == null) {
            this.match = new OFMatch();
        }
        this.match.readFrom(data);
        this.cookie = data.getLong();
        this.command = data.getShort();
        this.idleTimeout = data.getShort();
        this.hardTimeout = data.getShort();
        this.priority = data.getShort();
        this.bufferId = data.getInt();
        this.outPort = data.getShort();
        this.flags = data.getShort();
        if (this.actionFactory == null) {
            throw new RuntimeException("OFActionFactory not set");
        }
        this.actions = this.actionFactory.parseActions(data, this.getLengthU() - MINIMUM_LENGTH);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        this.match.writeTo(data);
        data.putLong(this.cookie);
        data.putShort(this.command);
        data.putShort(this.idleTimeout);
        data.putShort(this.hardTimeout);
        data.putShort(this.priority);
        data.putInt(this.bufferId);
        data.putShort(this.outPort);
        data.putShort(this.flags);
        if (this.actions != null) {
            for (OFAction action : this.actions) {
                action.writeTo(data);
            }
        }
    }

    @Override
    public void setActionFactory(OFActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    @Override
    public int hashCode() {
        int prime = 227;
        int result = super.hashCode();
        result = 227 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 227 * result + this.bufferId;
        result = 227 * result + this.command;
        result = 227 * result + (int)(this.cookie ^ this.cookie >>> 32);
        result = 227 * result + this.flags;
        result = 227 * result + this.hardTimeout;
        result = 227 * result + this.idleTimeout;
        result = 227 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 227 * result + this.outPort;
        result = 227 * result + this.priority;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFFlowMod)) {
            return false;
        }
        OFFlowMod other = (OFFlowMod)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.bufferId != other.bufferId) {
            return false;
        }
        if (this.command != other.command) {
            return false;
        }
        if (this.cookie != other.cookie) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.outPort != other.outPort) {
            return false;
        }
        return this.priority == other.priority;
    }

    public OFFlowMod clone() {
        try {
            OFMatch neoMatch = this.match.clone();
            OFFlowMod flowMod = (OFFlowMod)super.clone();
            flowMod.setMatch(neoMatch);
            LinkedList<OFAction> neoActions = new LinkedList<OFAction>();
            for (OFAction action : this.actions) {
                neoActions.add(action.clone());
            }
            flowMod.setActions(neoActions);
            return flowMod;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "OFFlowMod [actionFactory=" + this.actionFactory + ", actions=" + this.actions + ", bufferId=" + this.bufferId + ", command=" + this.command + ", cookie=" + this.cookie + ", flags=" + this.flags + ", hardTimeout=" + this.hardTimeout + ", idleTimeout=" + this.idleTimeout + ", match=" + this.match + ", outPort=" + this.outPort + ", priority=" + this.priority + ", length=" + this.length + ", type=" + (Object)((Object)this.type) + ", version=" + this.version + ", xid=" + this.xid + "]";
    }
}

