/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPhysicalPort;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFFeaturesReply
extends OFMessage
implements Serializable {
    public static int MINIMUM_LENGTH = 32;
    protected long datapathId;
    protected int buffers;
    protected byte tables;
    protected int capabilities;
    protected int actions;
    protected List<OFPhysicalPort> ports;

    public OFFeaturesReply() {
        this.type = OFType.FEATURES_REPLY;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public long getDatapathId() {
        return this.datapathId;
    }

    public void setDatapathId(long datapathId) {
        this.datapathId = datapathId;
    }

    public int getBuffers() {
        return this.buffers;
    }

    public void setBuffers(int buffers) {
        this.buffers = buffers;
    }

    public byte getTables() {
        return this.tables;
    }

    public void setTables(byte tables) {
        this.tables = tables;
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(int capabilities) {
        this.capabilities = capabilities;
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public List<OFPhysicalPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<OFPhysicalPort> ports) {
        this.ports = ports;
        if (ports == null) {
            this.setLengthU(MINIMUM_LENGTH);
        } else {
            this.setLengthU(MINIMUM_LENGTH + ports.size() * OFPhysicalPort.MINIMUM_LENGTH);
        }
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.datapathId = data.getLong();
        this.buffers = data.getInt();
        this.tables = data.get();
        data.position(data.position() + 3);
        this.capabilities = data.getInt();
        this.actions = data.getInt();
        if (this.ports == null) {
            this.ports = new ArrayList<OFPhysicalPort>();
        } else {
            this.ports.clear();
        }
        int portCount = (super.getLengthU() - 32) / OFPhysicalPort.MINIMUM_LENGTH;
        for (int i = 0; i < portCount; ++i) {
            OFPhysicalPort port = new OFPhysicalPort();
            port.readFrom(data);
            this.ports.add(port);
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putLong(this.datapathId);
        data.putInt(this.buffers);
        data.put(this.tables);
        data.putShort((short)0);
        data.put((byte)0);
        data.putInt(this.capabilities);
        data.putInt(this.actions);
        if (this.ports != null) {
            for (OFPhysicalPort port : this.ports) {
                port.writeTo(data);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 139;
        int result = super.hashCode();
        result = 139 * result + this.actions;
        result = 139 * result + this.buffers;
        result = 139 * result + this.capabilities;
        result = 139 * result + (int)(this.datapathId ^ this.datapathId >>> 32);
        result = 139 * result + (this.ports == null ? 0 : this.ports.hashCode());
        result = 139 * result + this.tables;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFFeaturesReply)) {
            return false;
        }
        OFFeaturesReply other = (OFFeaturesReply)obj;
        if (this.actions != other.actions) {
            return false;
        }
        if (this.buffers != other.buffers) {
            return false;
        }
        if (this.capabilities != other.capabilities) {
            return false;
        }
        if (this.datapathId != other.datapathId) {
            return false;
        }
        if (this.ports == null ? other.ports != null : !this.ports.equals(other.ports)) {
            return false;
        }
        return this.tables == other.tables;
    }

    public static enum OFCapabilities {
        OFPC_FLOW_STATS(1),
        OFPC_TABLE_STATS(2),
        OFPC_PORT_STATS(4),
        OFPC_STP(8),
        OFPC_RESERVED(16),
        OFPC_IP_REASM(32),
        OFPC_QUEUE_STATS(64),
        OFPC_ARP_MATCH_IP(128);

        protected int value;

        private OFCapabilities(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

