/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.protocol.factory.OFMessageFactory;
import org.openflow.protocol.factory.OFMessageFactoryAware;
import org.openflow.util.U16;

public class OFError
extends OFMessage
implements OFMessageFactoryAware {
    public static int MINIMUM_LENGTH = 12;
    protected short errorType;
    protected short errorCode;
    protected OFMessageFactory factory;
    protected byte[] error;
    protected boolean errorIsAscii;

    public OFError() {
        this.type = OFType.ERROR;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public short getErrorType() {
        return this.errorType;
    }

    public void setErrorType(short errorType) {
        this.errorType = errorType;
    }

    public void setErrorType(OFErrorType type) {
        this.errorType = (short)type.ordinal();
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(OFHelloFailedCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public void setErrorCode(short errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorCode(OFBadRequestCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public void setErrorCode(OFBadActionCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public void setErrorCode(OFFlowModFailedCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public void setErrorCode(OFPortModFailedCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public void setErrorCode(OFQueueOpFailedCode code) {
        this.errorCode = (short)code.ordinal();
    }

    public OFMessage getOffendingMsg() {
        if (this.error == null) {
            return null;
        }
        ByteBuffer errorMsg = ByteBuffer.wrap(this.error);
        if (this.factory == null) {
            throw new RuntimeException("MessageFactory not set");
        }
        List<OFMessage> messages = this.factory.parseMessages(errorMsg, this.error.length);
        if (messages.size() > 0) {
            return messages.get(0);
        }
        return null;
    }

    public void setOffendingMsg(OFMessage offendingMsg) {
        if (offendingMsg == null) {
            super.setLengthU(MINIMUM_LENGTH);
        } else {
            this.error = new byte[offendingMsg.getLengthU()];
            ByteBuffer data = ByteBuffer.wrap(this.error);
            offendingMsg.writeTo(data);
            super.setLengthU(MINIMUM_LENGTH + offendingMsg.getLengthU());
        }
    }

    public OFMessageFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setMessageFactory(OFMessageFactory factory) {
        this.factory = factory;
    }

    public byte[] getError() {
        return this.error;
    }

    public void setError(byte[] error) {
        this.error = error;
    }

    public boolean isErrorIsAscii() {
        return this.errorIsAscii;
    }

    public void setErrorIsAscii(boolean errorIsAscii) {
        this.errorIsAscii = errorIsAscii;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.errorType = data.getShort();
        this.errorCode = data.getShort();
        int dataLength = this.getLengthU() - MINIMUM_LENGTH;
        if (dataLength > 0) {
            this.error = new byte[dataLength];
            data.get(this.error);
            if (this.errorType == OFErrorType.OFPET_HELLO_FAILED.ordinal()) {
                this.errorIsAscii = true;
            }
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.errorType);
        data.putShort(this.errorCode);
        if (this.error != null) {
            data.put(this.error);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.error);
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.errorIsAscii ? 1231 : 1237);
        result = 31 * result + this.errorType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFError other = (OFError)obj;
        if (!Arrays.equals(this.error, other.error)) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorIsAscii != other.errorIsAscii) {
            return false;
        }
        return this.errorType == other.errorType;
    }

    public static enum OFQueueOpFailedCode {
        OFPQOFC_BAD_PORT,
        OFPQOFC_BAD_QUEUE,
        OFPQOFC_EPERM;

    }

    public static enum OFPortModFailedCode {
        OFPPMFC_BAD_PORT,
        OFPPMFC_BAD_HW_ADDR;

    }

    public static enum OFFlowModFailedCode {
        OFPFMFC_ALL_TABLES_FULL,
        OFPFMFC_OVERLAP,
        OFPFMFC_EPERM,
        OFPFMFC_BAD_EMERG_TIMEOUT,
        OFPFMFC_BAD_COMMAND,
        OFPFMFC_UNSUPPORTED;

    }

    public static enum OFBadActionCode {
        OFPBAC_BAD_TYPE,
        OFPBAC_BAD_LEN,
        OFPBAC_BAD_VENDOR,
        OFPBAC_BAD_VENDOR_TYPE,
        OFPBAC_BAD_OUT_PORT,
        OFPBAC_BAD_ARGUMENT,
        OFPBAC_EPERM,
        OFPBAC_TOO_MANY,
        OFPBAC_BAD_QUEUE;

    }

    public static enum OFBadRequestCode {
        OFPBRC_BAD_VERSION,
        OFPBRC_BAD_TYPE,
        OFPBRC_BAD_STAT,
        OFPBRC_BAD_VENDOR,
        OFPBRC_BAD_SUBTYPE,
        OFPBRC_EPERM,
        OFPBRC_BAD_LEN,
        OFPBRC_BUFFER_EMPTY,
        OFPBRC_BUFFER_UNKNOWN;

    }

    public static enum OFHelloFailedCode {
        OFPHFC_INCOMPATIBLE,
        OFPHFC_EPERM;

    }

    public static enum OFErrorType {
        OFPET_HELLO_FAILED,
        OFPET_BAD_REQUEST,
        OFPET_BAD_ACTION,
        OFPET_FLOW_MOD_FAILED,
        OFPET_PORT_MOD_FAILED,
        OFPET_QUEUE_OP_FAILED;

    }
}

