/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.openflow.io.OFMessageInStream;
import org.openflow.io.OFMessageOutStream;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.factory.OFMessageFactory;

public class OFMessageAsyncStream
implements OFMessageInStream,
OFMessageOutStream {
    public static int defaultBufferSize = 0x100000;
    protected ByteBuffer inBuf = ByteBuffer.allocateDirect(defaultBufferSize);
    protected ByteBuffer outBuf = ByteBuffer.allocateDirect(defaultBufferSize);
    protected OFMessageFactory messageFactory;
    protected SocketChannel sock;
    protected int partialReadCount = 0;

    public OFMessageAsyncStream(SocketChannel sock, OFMessageFactory messageFactory) throws IOException {
        this.sock = sock;
        this.messageFactory = messageFactory;
        this.sock.configureBlocking(false);
    }

    @Override
    public List<OFMessage> read() throws IOException {
        return this.read(0);
    }

    @Override
    public List<OFMessage> read(int limit) throws IOException {
        int read = this.sock.read(this.inBuf);
        if (read == -1) {
            return null;
        }
        this.inBuf.flip();
        List<OFMessage> l = this.messageFactory.parseMessages(this.inBuf, limit);
        if (this.inBuf.hasRemaining()) {
            this.inBuf.compact();
        } else {
            this.inBuf.clear();
        }
        return l;
    }

    protected void appendMessageToOutBuf(OFMessage m) throws IOException {
        int msglen = m.getLengthU();
        if (this.outBuf.remaining() < msglen) {
            throw new IOException("Message length exceeds buffer capacity: " + msglen);
        }
        m.writeTo(this.outBuf);
    }

    @Override
    public void write(OFMessage m) throws IOException {
        this.appendMessageToOutBuf(m);
    }

    @Override
    public void write(List<OFMessage> l) throws IOException {
        for (OFMessage m : l) {
            this.appendMessageToOutBuf(m);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outBuf.flip();
        this.sock.write(this.outBuf);
        this.outBuf.compact();
    }

    @Override
    public boolean needsFlush() {
        return this.outBuf.position() > 0;
    }

    @Override
    public OFMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public void setMessageFactory(OFMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }
}

