/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.example.cli;

import java.io.PrintStream;
import org.openflow.example.cli.Option;
import org.openflow.example.cli.Options;
import org.openflow.example.cli.ParseException;

public class SimpleCLI {
    private static final String NAME_WIDTH = "-15";
    private static final String VALUE_WIDTH = "-20";
    private static final String FORMAT_STRING = "%1$-15s%2$-20s%3$s\n";
    Options options;
    int optind;

    private SimpleCLI(Options options) {
        this.options = options;
    }

    public int getOptind() {
        return this.optind;
    }

    public void setOptind(int optind) {
        this.optind = optind;
    }

    public boolean hasOption(String shortName) {
        Option option = this.options.getOption(shortName);
        if (option == null) {
            return false;
        }
        return option.specified;
    }

    public String getOptionValue(String shortName) {
        Option option = this.options.getOption(shortName);
        if (option == null) {
            return null;
        }
        if (!option.specified) {
            return option.defaultVal.toString();
        }
        return option.val;
    }

    public static SimpleCLI parse(Options options, String[] args) throws ParseException {
        int i;
        SimpleCLI simpleCLI = new SimpleCLI(options);
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String optName = args[i].replaceFirst("^-*", "");
            Option option = args[i].startsWith("--") ? options.getOptionByLongName(optName) : options.getOption(optName);
            if (option == null) {
                throw new ParseException("unknown option: " + optName);
            }
            option.specified = true;
            if (!option.needsArg()) continue;
            if (i + 1 >= args.length) {
                throw new ParseException("option " + optName + " requires an argument:: " + option.comment);
            }
            option.val = args[i + 1];
            ++i;
        }
        simpleCLI.setOptind(i);
        return simpleCLI;
    }

    public static void printHelp(String canonicalName, Options options) {
        SimpleCLI.printHelp(canonicalName, options, System.err);
    }

    private static void printHelp(String helpString, Options options, PrintStream err) {
        err.println(helpString);
        err.format(FORMAT_STRING, "\toption", "type [default]", "usage");
        for (Option option : options.getOptions()) {
            String msg = "\t";
            if (option.shortOpt != null) {
                msg = msg + "-" + option.shortOpt;
            }
            if (option.longOpt != null) {
                if (!msg.equals("\t")) {
                    msg = msg + "|";
                }
                msg = msg + "--" + option.longOpt;
            }
            String val = "";
            if (option.defaultVal != null) {
                val = val + option.defaultVal.getClass().getSimpleName() + " [" + option.defaultVal.toString() + "]";
            }
            String comment = option.comment != null ? option.comment : "";
            err.format(FORMAT_STRING, msg, val, comment);
        }
        err.println("");
    }
}

