/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.example;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openflow.example.SelectListener;
import org.openflow.example.SelectLoop;
import org.openflow.example.cli.Options;
import org.openflow.example.cli.ParseException;
import org.openflow.example.cli.SimpleCLI;
import org.openflow.io.OFMessageAsyncStream;
import org.openflow.protocol.OFEchoReply;
import org.openflow.protocol.OFFlowMod;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPacketIn;
import org.openflow.protocol.OFPacketOut;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionOutput;
import org.openflow.protocol.factory.BasicFactory;
import org.openflow.util.LRULinkedHashMap;
import org.openflow.util.U16;

public class SimpleController
implements SelectListener {
    protected ExecutorService es;
    protected BasicFactory factory;
    protected SelectLoop listenSelectLoop;
    protected ServerSocketChannel listenSock = ServerSocketChannel.open();
    protected List<SelectLoop> switchSelectLoops;
    protected Map<SocketChannel, OFSwitch> switchSockets;
    protected Integer threadCount;
    protected int port;

    public SimpleController(int port) throws IOException {
        this.listenSock.configureBlocking(false);
        this.listenSock.socket().bind(new InetSocketAddress(port));
        this.listenSock.socket().setReuseAddress(true);
        this.port = port;
        this.switchSelectLoops = new ArrayList<SelectLoop>();
        this.switchSockets = new ConcurrentHashMap<SocketChannel, OFSwitch>();
        this.threadCount = 1;
        this.listenSelectLoop = new SelectLoop(this);
        this.listenSelectLoop.register(this.listenSock, 16, this.listenSock);
        this.factory = new BasicFactory();
    }

    @Override
    public void handleEvent(SelectionKey key, Object arg) throws IOException {
        if (arg instanceof ServerSocketChannel) {
            this.handleListenEvent(key, (ServerSocketChannel)arg);
        } else {
            this.handleSwitchEvent(key, (SocketChannel)arg);
        }
    }

    protected void handleListenEvent(SelectionKey key, ServerSocketChannel ssc) throws IOException {
        SocketChannel sock = this.listenSock.accept();
        OFMessageAsyncStream stream = new OFMessageAsyncStream(sock, this.factory);
        this.switchSockets.put(sock, new OFSwitch(sock, stream));
        System.err.println("Got new connection from " + this.switchSockets.get(sock));
        ArrayList<OFMessage> l = new ArrayList<OFMessage>();
        l.add(this.factory.getMessage(OFType.HELLO));
        l.add(this.factory.getMessage(OFType.FEATURES_REQUEST));
        stream.write(l);
        int ops = 1;
        if (stream.needsFlush()) {
            ops |= 4;
        }
        SelectLoop sl = this.switchSelectLoops.get(sock.hashCode() % this.switchSelectLoops.size());
        sl.register(sock, ops, sock);
        sl.wakeup();
    }

    protected void handleSwitchEvent(SelectionKey key, SocketChannel sock) {
        OFSwitch sw = this.switchSockets.get(sock);
        OFMessageAsyncStream stream = sw.getStream();
        try {
            if (key.isReadable()) {
                List<OFMessage> msgs = stream.read();
                if (msgs == null) {
                    key.cancel();
                    this.switchSockets.remove(sock);
                    return;
                }
                block7: for (OFMessage m : msgs) {
                    switch (m.getType()) {
                        case PACKET_IN: {
                            sw.handlePacketIn((OFPacketIn)m);
                            continue block7;
                        }
                        case HELLO: {
                            System.err.println("GOT HELLO from " + sw);
                            continue block7;
                        }
                        case ECHO_REQUEST: {
                            OFEchoReply reply = (OFEchoReply)stream.getMessageFactory().getMessage(OFType.ECHO_REPLY);
                            reply.setXid(m.getXid());
                            stream.write(reply);
                            continue block7;
                        }
                    }
                    System.err.println("Unhandled OF message: " + (Object)((Object)m.getType()) + " from " + sock.socket().getInetAddress());
                }
            }
            if (key.isWritable()) {
                stream.flush();
            }
            if (stream.needsFlush()) {
                key.interestOps(4);
            } else {
                key.interestOps(1);
            }
        }
        catch (IOException e) {
            key.cancel();
            this.switchSockets.remove(sock);
        }
    }

    public void run() throws IOException {
        System.err.println("Starting " + this.getClass().getCanonicalName() + " on port " + this.port + " with " + this.threadCount + " threads");
        this.es = Executors.newFixedThreadPool(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            final SelectLoop sl = new SelectLoop(this);
            this.switchSelectLoops.add(sl);
            this.es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        sl.doLoop();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        this.listenSelectLoop.doLoop();
    }

    public static void main(String[] args) throws IOException {
        SimpleCLI cmd = SimpleController.parseArgs(args);
        int port = Integer.valueOf(cmd.getOptionValue("p"));
        SimpleController sc = new SimpleController(port);
        sc.threadCount = Integer.valueOf(cmd.getOptionValue("t"));
        sc.run();
    }

    public static SimpleCLI parseArgs(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", "print help");
        options.addOption("p", "port", 6633, "the port to listen on");
        options.addOption("t", "threads", 1, "the number of threads to run");
        try {
            SimpleCLI cmd = SimpleCLI.parse(options, args);
            if (cmd.hasOption("h")) {
                SimpleController.printUsage(options);
                System.exit(0);
            }
            return cmd;
        }
        catch (ParseException e) {
            System.err.println(e);
            SimpleController.printUsage(options);
            System.exit(-1);
            return null;
        }
    }

    public static void printUsage(Options options) {
        SimpleCLI.printHelp("Usage: " + SimpleController.class.getCanonicalName() + " [options]", options);
    }

    protected class OFSwitch {
        protected SocketChannel sock;
        protected OFMessageAsyncStream stream;
        protected Map<Integer, Short> macTable = new LRULinkedHashMap<Integer, Short>(64001, 64000);

        public OFSwitch(SocketChannel sock, OFMessageAsyncStream stream) {
            this.sock = sock;
            this.stream = stream;
        }

        public void handlePacketIn(OFPacketIn pi) {
            ArrayList<OFAction> actions;
            OFActionOutput action;
            OFMatch match = new OFMatch();
            match.loadFromPacket(pi.getPacketData(), pi.getInPort());
            byte[] dlDst = match.getDataLayerDestination();
            Integer dlDstKey = Arrays.hashCode(dlDst);
            byte[] dlSrc = match.getDataLayerSource();
            Integer dlSrcKey = Arrays.hashCode(dlSrc);
            int bufferId = pi.getBufferId();
            if (!((dlSrc[0] & 1) != 0 || this.macTable.containsKey(dlSrcKey) && this.macTable.get(dlSrcKey).equals(pi.getInPort()))) {
                this.macTable.put(dlSrcKey, pi.getInPort());
            }
            Short outPort = null;
            if ((dlDst[0] & 1) == 0) {
                outPort = this.macTable.get(dlDstKey);
            }
            if (outPort != null) {
                OFFlowMod fm = (OFFlowMod)SimpleController.this.factory.getMessage(OFType.FLOW_MOD);
                fm.setBufferId(bufferId);
                fm.setCommand((short)0);
                fm.setCookie(0L);
                fm.setFlags((short)0);
                fm.setHardTimeout((short)0);
                fm.setIdleTimeout((short)5);
                match.setInputPort(pi.getInPort());
                match.setWildcards(0);
                fm.setMatch(match);
                fm.setOutPort(OFPort.OFPP_NONE.getValue());
                fm.setPriority((short)0);
                action = new OFActionOutput();
                action.setMaxLength((short)0);
                action.setPort(outPort);
                actions = new ArrayList();
                actions.add(action);
                fm.setActions(actions);
                fm.setLength(U16.t(OFFlowMod.MINIMUM_LENGTH + OFActionOutput.MINIMUM_LENGTH));
                try {
                    this.stream.write(fm);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outPort == null || pi.getBufferId() == -1) {
                OFPacketOut po = new OFPacketOut();
                po.setBufferId(bufferId);
                po.setInPort(pi.getInPort());
                action = new OFActionOutput();
                action.setMaxLength((short)0);
                action.setPort(outPort == null ? OFPort.OFPP_FLOOD.getValue() : outPort.shortValue());
                actions = new ArrayList<OFAction>();
                actions.add(action);
                po.setActions(actions);
                po.setActionsLength((short)OFActionOutput.MINIMUM_LENGTH);
                if (bufferId == -1) {
                    byte[] packetData = pi.getPacketData();
                    po.setLength(U16.t(OFPacketOut.MINIMUM_LENGTH + po.getActionsLength() + packetData.length));
                    po.setPacketData(packetData);
                } else {
                    po.setLength(U16.t(OFPacketOut.MINIMUM_LENGTH + po.getActionsLength()));
                }
                try {
                    this.stream.write(po);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            InetAddress remote = this.sock.socket().getInetAddress();
            return remote.getHostAddress() + ":" + this.sock.socket().getPort();
        }

        public OFMessageAsyncStream getStream() {
            return this.stream;
        }
    }
}

