/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.example;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openflow.example.SelectListener;

public class SelectLoop {
    protected SelectListener callback;
    protected boolean dontStop;
    protected Object registrationLock;
    protected int registrationRequests = 0;
    protected Queue<Object[]> registrationQueue;
    protected Selector selector;
    protected long timeout;

    public SelectLoop(SelectListener cb) throws IOException {
        this.callback = cb;
        this.dontStop = true;
        this.selector = SelectorProvider.provider().openSelector();
        this.registrationLock = new Object();
        this.registrationQueue = new ConcurrentLinkedQueue<Object[]>();
        this.timeout = 0L;
    }

    public SelectLoop(SelectListener cb, long timeout) throws IOException {
        this.callback = cb;
        this.dontStop = true;
        this.selector = SelectorProvider.provider().openSelector();
        this.registrationLock = new Object();
        this.registrationQueue = new ConcurrentLinkedQueue<Object[]>();
        this.timeout = timeout;
    }

    public void register(SelectableChannel ch, int ops, Object arg) throws ClosedChannelException {
        this.registrationQueue.add(new Object[]{ch, ops, arg});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SelectionKey registerBlocking(SelectableChannel ch, int ops, Object arg) throws ClosedChannelException {
        Object object = this.registrationLock;
        synchronized (object) {
            ++this.registrationRequests;
        }
        this.selector.wakeup();
        SelectionKey key = ch.register(this.selector, ops, arg);
        Object object2 = this.registrationLock;
        synchronized (object2) {
            --this.registrationRequests;
            this.registrationLock.notifyAll();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoop() throws IOException {
        this.processRegistrationQueue();
        while (this.dontStop) {
            int nEvents = this.selector.select(this.timeout);
            if (nEvents > 0) {
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey sk = i.next();
                    i.remove();
                    if (!sk.isValid()) continue;
                    Object arg = sk.attachment();
                    this.callback.handleEvent(sk, arg);
                }
            }
            if (this.registrationQueue.size() > 0) {
                this.processRegistrationQueue();
            }
            if (this.registrationRequests <= 0) continue;
            Object object = this.registrationLock;
            synchronized (object) {
                while (this.registrationRequests > 0) {
                    try {
                        this.registrationLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void processRegistrationQueue() {
        Iterator it = this.registrationQueue.iterator();
        while (it.hasNext()) {
            Object[] args = (Object[])it.next();
            SelectableChannel ch = (SelectableChannel)args[0];
            try {
                ch.register(this.selector, (Integer)args[1], args[2]);
            }
            catch (CancelledKeyException cke) {
                continue;
            }
            catch (ClosedChannelException e) {
                // empty catch block
            }
            it.remove();
        }
    }

    public void wakeup() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    public void shutdown() {
        this.dontStop = false;
        this.wakeup();
    }
}

