/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.transactions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProvider
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TransactionProvider.class);
    private final ConfigRegistryClient configRegistryClient;
    private final String netconfSessionIdForReporting;
    private ObjectName transaction;
    private final List<ObjectName> allOpenedTransactions = new ArrayList<ObjectName>();

    public TransactionProvider(ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        this.configRegistryClient = configRegistryClient;
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
    }

    @Override
    public synchronized void close() {
        for (ObjectName tx : this.allOpenedTransactions) {
            try {
                if (!this.isStillOpenTransaction(tx)) continue;
                this.configRegistryClient.getConfigTransactionClient(tx).abortConfig();
            }
            catch (Exception e) {
                logger.debug("Ignoring exception while closing transaction {}", (Object)tx, (Object)e);
            }
        }
        this.allOpenedTransactions.clear();
    }

    public Optional<ObjectName> getTransaction() {
        if (this.transaction == null) {
            return Optional.absent();
        }
        if (!this.isStillOpenTransaction(this.transaction)) {
            logger.warn("Fixing illegal state: transaction {} was closed in {}", (Object)this.transaction, (Object)this.netconfSessionIdForReporting);
            this.transaction = null;
            return Optional.absent();
        }
        return Optional.of((Object)this.transaction);
    }

    private boolean isStillOpenTransaction(ObjectName transaction) {
        boolean isStillOpenTransaction = this.configRegistryClient.getOpenConfigs().contains(transaction);
        return isStillOpenTransaction;
    }

    public synchronized ObjectName getOrCreateTransaction() {
        Optional<ObjectName> ta = this.getTransaction();
        if (ta.isPresent()) {
            return (ObjectName)ta.get();
        }
        this.transaction = this.configRegistryClient.beginConfig();
        this.allOpenedTransactions.add(this.transaction);
        return this.transaction;
    }

    public synchronized ObjectName getTestTransaction() {
        ObjectName testTx = this.configRegistryClient.beginConfig();
        this.allOpenedTransactions.add(testTx);
        return testTx;
    }

    public synchronized CommitStatus commitTransaction() throws NetconfDocumentedException {
        Optional<ObjectName> maybeTaON = this.getTransaction();
        Preconditions.checkState((boolean)maybeTaON.isPresent(), (Object)("No transaction found for session " + this.netconfSessionIdForReporting));
        ObjectName taON = (ObjectName)maybeTaON.get();
        try {
            CommitStatus status = this.configRegistryClient.commitConfig(taON);
            this.allOpenedTransactions.remove(this.transaction);
            this.transaction = null;
            return status;
        }
        catch (ValidationException validationException) {
            logger.warn("Transaction {} failed on {}", (Object)taON, (Object)validationException.toString());
            throw validationException;
        }
        catch (Exception e) {
            logger.error("Exception while commit of {}, aborting transaction", (Object)taON, (Object)e);
            this.abortTransaction();
            throw e;
        }
    }

    public synchronized void abortTransaction() {
        logger.debug("Aborting current transaction");
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)("No transaction found for session " + this.netconfSessionIdForReporting));
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient((ObjectName)taON.get());
        transactionClient.abortConfig();
        this.allOpenedTransactions.remove(this.transaction);
        this.transaction = null;
    }

    public synchronized void abortTestTransaction(ObjectName testTx) {
        logger.debug("Aborting transaction {}", (Object)testTx);
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(testTx);
        this.allOpenedTransactions.remove(testTx);
        transactionClient.abortConfig();
    }

    public void validateTransaction() throws ValidationException {
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)("No transaction found for session " + this.netconfSessionIdForReporting));
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient((ObjectName)taON.get());
        transactionClient.validateConfig();
    }

    public void validateTestTransaction(ObjectName taON) {
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(taON);
        transactionClient.validateConfig();
    }

    public void wipeTestTransaction(ObjectName taON) {
        this.wipeInternal(taON, true, null);
    }

    synchronized void wipeInternal(ObjectName taON, boolean isTest, String moduleName) {
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(taON);
        Set lookupConfigBeans = moduleName == null ? transactionClient.lookupConfigBeans() : transactionClient.lookupConfigBeans(moduleName);
        int i = lookupConfigBeans.size();
        for (ObjectName instance : lookupConfigBeans) {
            try {
                transactionClient.destroyModule(instance);
            }
            catch (InstanceNotFoundException e) {
                if (isTest) {
                    logger.debug("Unable to clean configuration in transactiom {}", (Object)taON, (Object)e);
                } else {
                    logger.warn("Unable to clean configuration in transactiom {}", (Object)taON, (Object)e);
                }
                throw new IllegalStateException("Unable to clean configuration in transactiom " + taON, e);
            }
        }
        logger.debug("Transaction {} wiped clean of {} config beans", (Object)taON, (Object)i);
        transactionClient.removeAllServiceReferences();
        logger.debug("Transaction {} wiped clean of all service references", (Object)taON);
    }

    public void wipeTransaction() {
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)("No transaction found for session " + this.netconfSessionIdForReporting));
        this.wipeInternal((ObjectName)taON.get(), false, null);
    }
}

