/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.osgi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.config.api.LookupRegistry;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreException;
import org.opendaylight.controller.config.yang.store.api.YangStoreService;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.netconf.confignetconfconnector.osgi.NetconfOperationProvider;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;
import org.opendaylight.controller.netconf.mapping.api.Capability;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilter;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.yangtools.yang.model.api.Module;

public class NetconfOperationServiceImpl
implements NetconfOperationService {
    private final YangStoreSnapshot yangStoreSnapshot;
    private final NetconfOperationProvider operationProvider;
    private final Set<Capability> capabilities;
    private final TransactionProvider transactionProvider;

    public NetconfOperationServiceImpl(YangStoreService yangStoreService, ConfigRegistryJMXClient jmxClient, String netconfSessionIdForReporting) throws YangStoreException {
        this.yangStoreSnapshot = yangStoreService.getYangStoreSnapshot();
        NetconfOperationServiceImpl.checkConsistencyBetweenYangStoreAndConfig((LookupRegistry)jmxClient, this.yangStoreSnapshot);
        this.transactionProvider = new TransactionProvider(jmxClient, netconfSessionIdForReporting);
        this.operationProvider = new NetconfOperationProvider(this.yangStoreSnapshot, jmxClient, this.transactionProvider, netconfSessionIdForReporting);
        this.capabilities = NetconfOperationServiceImpl.setupCapabilities(this.yangStoreSnapshot);
    }

    @VisibleForTesting
    static void checkConsistencyBetweenYangStoreAndConfig(LookupRegistry jmxClient, YangStoreSnapshot yangStoreSnapshot) {
        HashSet missingModulesFromConfig = Sets.newHashSet();
        Set modulesSeenByConfig = jmxClient.getAvailableModuleFactoryQNames();
        Map moduleMXBeanEntryMap = yangStoreSnapshot.getModuleMXBeanEntryMap();
        for (Map moduleNameToMBE : moduleMXBeanEntryMap.values()) {
            for (ModuleMXBeanEntry moduleMXBeanEntry : moduleNameToMBE.values()) {
                String moduleSeenByYangStore = moduleMXBeanEntry.getYangModuleQName().toString();
                if (modulesSeenByConfig.contains(moduleSeenByYangStore)) continue;
                missingModulesFromConfig.add(moduleSeenByYangStore);
            }
        }
        Preconditions.checkState((boolean)missingModulesFromConfig.isEmpty(), (String)"There are inconsistencies between configuration subsystem and yangstore in terms of discovered yang modules, yang modules missing from config subsystem but present in yangstore: %s, %sAll modules present in config: %s", (Object[])new Object[]{missingModulesFromConfig, System.lineSeparator(), modulesSeenByConfig});
    }

    public void close() {
        this.yangStoreSnapshot.close();
        this.transactionProvider.close();
    }

    public Set<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Set<NetconfOperation> getNetconfOperations() {
        return this.operationProvider.getOperations();
    }

    public Set<NetconfOperationFilter> getFilters() {
        return Collections.emptySet();
    }

    private static Set<Capability> setupCapabilities(YangStoreSnapshot yangStoreSnapshot) {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        capabilities.add(new BasicCapability("urn:ietf:params:netconf:capability:candidate:1.0"));
        capabilities.add(new BasicCapability("urn:ietf:params:netconf:capability:rollback-on-error:1.0"));
        Set modules = yangStoreSnapshot.getModules();
        for (Module module : modules) {
            capabilities.add(new YangStoreCapability(module, yangStoreSnapshot.getModuleSource(module)));
        }
        return capabilities;
    }

    private static class YangStoreCapability
    extends BasicCapability {
        private final String content;
        private final String revision;
        private final String moduleName;
        private final String moduleNamespace;

        public YangStoreCapability(Module module, String moduleContent) {
            super(YangStoreCapability.getAsString(module));
            this.content = moduleContent;
            this.moduleName = module.getName();
            this.moduleNamespace = module.getNamespace().toString();
            this.revision = Util.writeDate(module.getRevision());
        }

        @Override
        public Optional<String> getCapabilitySchema() {
            return Optional.of((Object)this.content);
        }

        private static String getAsString(Module module) {
            StringBuffer capabilityContent = new StringBuffer();
            capabilityContent.append(module.getNamespace());
            capabilityContent.append("?module=");
            capabilityContent.append(module.getName());
            capabilityContent.append("&revision=");
            capabilityContent.append(Util.writeDate(module.getRevision()));
            return capabilityContent.toString();
        }

        @Override
        public Optional<String> getModuleName() {
            return Optional.of((Object)this.moduleName);
        }

        @Override
        public Optional<String> getModuleNamespace() {
            return Optional.of((Object)this.moduleNamespace);
        }

        @Override
        public Optional<String> getRevision() {
            return Optional.of((Object)this.revision);
        }
    }

    private static class BasicCapability
    implements Capability {
        private final String capability;

        private BasicCapability(String capability) {
            this.capability = capability;
        }

        public String getCapabilityUri() {
            return this.capability;
        }

        public Optional<String> getModuleNamespace() {
            return Optional.absent();
        }

        public Optional<String> getModuleName() {
            return Optional.absent();
        }

        public Optional<String> getRevision() {
            return Optional.absent();
        }

        public Optional<String> getCapabilitySchema() {
            return Optional.absent();
        }

        public Optional<List<String>> getLocation() {
            return Optional.absent();
        }
    }
}

