/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.osgi;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreException;
import org.opendaylight.controller.config.yang.store.api.YangStoreService;
import org.opendaylight.controller.netconf.confignetconfconnector.osgi.NetconfOperationServiceImpl;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfOperationServiceFactoryImpl
implements NetconfOperationServiceFactory {
    public static final int ATTEMPT_TIMEOUT_MS = 1000;
    private static final int SILENT_ATTEMPTS = 30;
    private final YangStoreService yangStoreService;
    private final ConfigRegistryJMXClient jmxClient;
    private static final Logger logger = LoggerFactory.getLogger(NetconfOperationServiceFactoryImpl.class);

    public NetconfOperationServiceFactoryImpl(YangStoreService yangStoreService) {
        this(yangStoreService, ManagementFactory.getPlatformMBeanServer());
    }

    public NetconfOperationServiceFactoryImpl(YangStoreService yangStoreService, MBeanServer mBeanServer) {
        ConfigRegistryJMXClient configRegistryJMXClient;
        this.yangStoreService = yangStoreService;
        int i = 0;
        while (true) {
            try {
                configRegistryJMXClient = new ConfigRegistryJMXClient(mBeanServer);
                break;
            }
            catch (IllegalStateException e) {
                if (++i > 30) {
                    logger.info("JMX client not created after {} attempts, still trying", (Object)i, (Object)e);
                } else {
                    logger.debug("JMX client could not be created, reattempting, try {}", (Object)i, (Object)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while reattempting connection", e1);
                }
            }
        }
        this.jmxClient = configRegistryJMXClient;
        if (i > 30) {
            logger.info("Created JMX client after {} attempts", (Object)i);
        } else {
            logger.debug("Created JMX client after {} attempts", (Object)i);
        }
    }

    public NetconfOperationServiceImpl createService(long netconfSessionId, String netconfSessionIdForReporting) {
        try {
            return new NetconfOperationServiceImpl(this.yangStoreService, this.jmxClient, netconfSessionIdForReporting);
        }
        catch (YangStoreException e) {
            throw new IllegalStateException(e);
        }
    }
}

