/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.osgi;

import com.google.common.base.Preconditions;
import java.util.Hashtable;
import org.opendaylight.controller.config.yang.store.api.YangStoreService;
import org.opendaylight.controller.netconf.confignetconfconnector.osgi.NetconfOperationServiceFactoryImpl;
import org.opendaylight.controller.netconf.confignetconfconnector.osgi.YangStoreServiceTracker;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
YangStoreServiceTracker.YangStoreTrackerListener {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    ServiceRegistration osgiRegistration;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        YangStoreServiceTracker tracker = new YangStoreServiceTracker(context, this);
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
    }

    @Override
    public synchronized void onYangStoreAdded(YangStoreService yangStoreService) {
        Preconditions.checkState((this.osgiRegistration == null ? 1 : 0) != 0, (Object)"More than one onYangStoreAdded received");
        NetconfOperationServiceFactoryImpl factory = new NetconfOperationServiceFactoryImpl(yangStoreService);
        logger.debug("Registering into OSGi");
        this.osgiRegistration = this.context.registerService(new String[]{NetconfOperationServiceFactory.class.getName()}, (Object)factory, new Hashtable());
    }

    @Override
    public synchronized void onYangStoreRemoved() {
        this.osgiRegistration.unregister();
        this.osgiRegistration = null;
    }
}

