/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.runtimerpc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.VoidAttribute;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.ObjectMapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.ObjectXmlWriter;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc.InstanceRuntimeRpc;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc.ModuleRpcs;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc.Rpcs;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Commit;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.runtimerpc.RuntimeRpcElementResolved;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RuntimeRpc
extends AbstractConfigNetconfOperation {
    private static final Logger logger = LoggerFactory.getLogger(Commit.class);
    public static final String CONTEXT_INSTANCE = "context-instance";
    private final YangStoreSnapshot yangStoreSnapshot;

    public RuntimeRpc(YangStoreSnapshot yangStoreSnapshot, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.yangStoreSnapshot = yangStoreSnapshot;
    }

    private Element toXml(Document doc, Object result, AttributeIfc returnType, String namespace, String elementName) {
        AttributeMappingStrategy<?, OpenType<?>> mappingStrategy = new ObjectMapper(null).prepareStrategy(returnType);
        Optional<?> mappedAttributeOpt = mappingStrategy.mapAttribute(result);
        Preconditions.checkState((boolean)mappedAttributeOpt.isPresent(), (String)"Unable to map return value %s as %s", (Object[])new Object[]{result, returnType.getOpenType()});
        Element tempParent = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "output");
        new ObjectXmlWriter().prepareWritingStrategy(elementName, returnType, doc).writeElement(tempParent, namespace, mappedAttributeOpt.get());
        XmlElement xmlElement = XmlElement.fromDomElement((Element)tempParent);
        return xmlElement.getChildElements().size() > 1 ? tempParent : xmlElement.getOnlyChildElement().getDomElement();
    }

    private Object executeOperation(ConfigRegistryClient configRegistryClient, ObjectName on, String name, Map<String, AttributeConfigElement> attributes) {
        Object[] params = new Object[attributes.size()];
        String[] signature = new String[attributes.size()];
        int i = 0;
        for (String attrName : attributes.keySet()) {
            AttributeConfigElement attribute = attributes.get(attrName);
            Optional<?> resolvedValueOpt = attribute.getResolvedValue();
            params[i] = resolvedValueOpt.isPresent() ? resolvedValueOpt.get() : attribute.getResolvedDefaultValue();
            signature[i] = resolvedValueOpt.isPresent() ? resolvedValueOpt.get().getClass().getName() : attribute.getResolvedDefaultValue().getClass().getName();
            ++i;
        }
        return configRegistryClient.invokeMethod(on, name, params, signature);
    }

    public NetconfOperationExecution fromXml(XmlElement xml) throws NetconfDocumentedException {
        String namespace = xml.getNamespace();
        XmlElement contextInstanceElement = xml.getOnlyChildElement(CONTEXT_INSTANCE);
        String operationName = xml.getName();
        RuntimeRpcElementResolved id = RuntimeRpcElementResolved.fromXpath(contextInstanceElement.getTextContent(), operationName, namespace);
        Rpcs rpcs = RuntimeRpc.mapRpcs(this.yangStoreSnapshot.getModuleMXBeanEntryMap());
        ModuleRpcs rpcMapping = rpcs.getRpcMapping(id);
        InstanceRuntimeRpc instanceRuntimeRpc = rpcMapping.getRpc(id.getRuntimeBeanName(), operationName);
        ObjectName on = id.getObjectName(rpcMapping);
        Map<String, AttributeConfigElement> attributes = instanceRuntimeRpc.fromXml(xml);
        attributes = RuntimeRpc.sortAttributes(attributes, xml);
        return new NetconfOperationExecution(on, instanceRuntimeRpc.getName(), attributes, instanceRuntimeRpc.getReturnType(), namespace);
    }

    public HandlingPriority canHandle(Document message) {
        XmlElement requestElement = RuntimeRpc.getRequestElementWithCheck((Document)message);
        XmlElement operationElement = requestElement.getOnlyChildElement();
        String netconfOperationName = operationElement.getName();
        String netconfOperationNamespace = operationElement.getNamespace();
        Optional contextInstanceElement = operationElement.getOnlyChildElementOptionally(CONTEXT_INSTANCE);
        if (!contextInstanceElement.isPresent()) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        RuntimeRpcElementResolved id = RuntimeRpcElementResolved.fromXpath(((XmlElement)contextInstanceElement.get()).getTextContent(), netconfOperationName, netconfOperationNamespace);
        Rpcs rpcs = RuntimeRpc.mapRpcs(this.yangStoreSnapshot.getModuleMXBeanEntryMap());
        try {
            ModuleRpcs rpcMapping = rpcs.getRpcMapping(id);
            InstanceRuntimeRpc instanceRuntimeRpc = rpcMapping.getRpc(id.getRuntimeBeanName(), netconfOperationName);
            Preconditions.checkState((instanceRuntimeRpc != null ? 1 : 0) != 0, (String)"No rpc found for %s:%s", (Object[])new Object[]{netconfOperationNamespace, netconfOperationName});
        }
        catch (IllegalStateException e) {
            logger.debug("Cannot handle runtime operation {}:{}", new Object[]{netconfOperationNamespace, netconfOperationName, e});
            return HandlingPriority.CANNOT_HANDLE;
        }
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    @Override
    protected HandlingPriority canHandle(String netconfOperationName, String namespace) {
        throw new UnsupportedOperationException("This should not be used since it is not possible to provide check with these attributes");
    }

    @Override
    protected String getOperationName() {
        throw new UnsupportedOperationException("Runtime rpc does not have a stable name");
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        NetconfOperationExecution execution = this.fromXml(xml);
        logger.debug("Invoking operation {} on {} with arguments {}", new Object[]{execution.operationName, execution.on, execution.attributes});
        Object result = this.executeOperation(this.configRegistryClient, execution.on, execution.operationName, execution.attributes);
        logger.trace("Operation {} called successfully on {} with arguments {} with result {}", new Object[]{execution.operationName, execution.on, execution.attributes, result});
        if (execution.isVoid()) {
            return document.createElement("ok");
        }
        return this.toXml(document, result, execution.returnType, execution.namespace, execution.returnType.getAttributeYangName());
    }

    private static Map<String, AttributeConfigElement> sortAttributes(Map<String, AttributeConfigElement> attributes, XmlElement xml) {
        LinkedHashMap sorted = Maps.newLinkedHashMap();
        for (XmlElement xmlElement : xml.getChildElements()) {
            String name = xmlElement.getName();
            if (CONTEXT_INSTANCE.equals(name)) continue;
            AttributeConfigElement value = attributes.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Cannot find yang mapping for node " + xmlElement);
            }
            sorted.put(name, value);
        }
        return sorted;
    }

    private static Rpcs mapRpcs(Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        HashMap map = Maps.newHashMap();
        for (String namespace : mBeanEntries.keySet()) {
            Map namespaceToModules = (Map)map.get(namespace);
            if (namespaceToModules == null) {
                namespaceToModules = Maps.newHashMap();
                map.put(namespace, namespaceToModules);
            }
            for (String moduleName : mBeanEntries.get(namespace).keySet()) {
                ModuleRpcs rpcMapping = (ModuleRpcs)namespaceToModules.get(moduleName);
                if (rpcMapping == null) {
                    rpcMapping = new ModuleRpcs();
                    namespaceToModules.put(moduleName, rpcMapping);
                }
                ModuleMXBeanEntry entry = mBeanEntries.get(namespace).get(moduleName);
                for (RuntimeBeanEntry runtimeEntry : entry.getRuntimeBeans()) {
                    rpcMapping.addNameMapping(runtimeEntry);
                    for (RuntimeBeanEntry.Rpc rpc : runtimeEntry.getRpcs()) {
                        rpcMapping.addRpc(runtimeEntry, rpc);
                    }
                }
            }
        }
        return new Rpcs(map);
    }

    private static class NetconfOperationExecution {
        private final ObjectName on;
        private final String operationName;
        private final Map<String, AttributeConfigElement> attributes;
        private final AttributeIfc returnType;
        private final String namespace;

        public NetconfOperationExecution(ObjectName on, String name, Map<String, AttributeConfigElement> attributes, AttributeIfc returnType, String namespace) {
            this.on = on;
            this.operationName = name;
            this.attributes = attributes;
            this.returnType = returnType;
            this.namespace = namespace;
        }

        boolean isVoid() {
            return this.returnType == VoidAttribute.getInstance();
        }
    }
}

