/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.getconfig;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Config;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetConfig
extends AbstractConfigNetconfOperation {
    public static final String GET_CONFIG = "get-config";
    private final YangStoreSnapshot yangStoreSnapshot;
    private final Optional<String> maybeNamespace;
    private final TransactionProvider transactionProvider;
    private static final Logger logger = LoggerFactory.getLogger(GetConfig.class);

    public GetConfig(YangStoreSnapshot yangStoreSnapshot, Optional<String> maybeNamespace, TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.yangStoreSnapshot = yangStoreSnapshot;
        this.maybeNamespace = maybeNamespace;
        this.transactionProvider = transactionProvider;
    }

    public static Datastore fromXml(XmlElement xml) {
        xml.checkName(GET_CONFIG);
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        XmlElement sourceElement = xml.getOnlyChildElement("source", "urn:ietf:params:xml:ns:netconf:base:1.0");
        XmlElement sourceNode = sourceElement.getOnlyChildElement();
        String sourceParsed = sourceNode.getName();
        logger.debug("Setting source datastore to '{}'", (Object)sourceParsed);
        Datastore sourceDatastore = Datastore.valueOf(sourceParsed);
        if (xml.getChildElements("filter").size() != 0) {
            throw new UnsupportedOperationException("Unsupported option filter for get-config");
        }
        return sourceDatastore;
    }

    private Element getResponseInternal(Document document, ConfigRegistryClient configRegistryClient, Datastore source) throws NetconfDocumentedException {
        Element dataElement = document.createElement("data");
        Set<ObjectName> instances = Datastore.getInstanceQueryStrategy(source, this.transactionProvider).queryInstances(configRegistryClient);
        Config configMapping = new Config(EditConfig.transformMbeToModuleConfigs(configRegistryClient, this.yangStoreSnapshot.getModuleMXBeanEntryMap()));
        ObjectName on = this.transactionProvider.getOrCreateTransaction();
        ConfigTransactionClient ta = configRegistryClient.getConfigTransactionClient(on);
        ServiceRegistryWrapper serviceTracker = new ServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta);
        dataElement = configMapping.toXml(instances, this.maybeNamespace, document, dataElement, serviceTracker);
        logger.trace("{} operation successful", (Object)GET_CONFIG);
        return dataElement;
    }

    @Override
    protected String getOperationName() {
        return GET_CONFIG;
    }

    @Override
    public Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        Datastore source;
        try {
            source = GetConfig.fromXml(xml);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.bad_attribute, (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (IllegalStateException e) {
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.missing_attribute, (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.missing_attribute.name(), "Missing datasource attribute value");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.missing_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Unsupported", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_not_supported.name(), "Unsupported option for get");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        return this.getResponseInternal(document, this.configRegistryClient, source);
    }
}

