/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.get;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime.InstanceRuntime;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime.ModuleRuntime;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime.Runtime;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Get
extends AbstractConfigNetconfOperation {
    private final YangStoreSnapshot yangStoreSnapshot;
    private static final Logger logger = LoggerFactory.getLogger(Get.class);
    private final TransactionProvider transactionProvider;

    public Get(YangStoreSnapshot yangStoreSnapshot, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.yangStoreSnapshot = yangStoreSnapshot;
        this.transactionProvider = transactionProvider;
    }

    private Map<String, Map<String, ModuleRuntime>> createModuleRuntimes(ConfigRegistryClient configRegistryClient, Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        HashMap retVal = Maps.newHashMap();
        for (String namespace : mBeanEntries.keySet()) {
            HashMap innerMap = Maps.newHashMap();
            Map<String, ModuleMXBeanEntry> entriesFromNamespace = mBeanEntries.get(namespace);
            for (String module : entriesFromNamespace.keySet()) {
                ModuleMXBeanEntry mbe = entriesFromNamespace.get(module);
                HashMap cache = Maps.newHashMap();
                RuntimeBeanEntry root = null;
                for (RuntimeBeanEntry rbe : mbe.getRuntimeBeans()) {
                    cache.put(rbe, new InstanceConfig(configRegistryClient, rbe.getYangPropertiesToTypesMap()));
                    if (!rbe.isRoot()) continue;
                    root = rbe;
                }
                if (root == null) continue;
                InstanceRuntime rootInstanceRuntime = this.createInstanceRuntime(root, cache);
                ModuleRuntime moduleRuntime = new ModuleRuntime(module, rootInstanceRuntime);
                innerMap.put(module, moduleRuntime);
            }
            retVal.put(namespace, innerMap);
        }
        return retVal;
    }

    private InstanceRuntime createInstanceRuntime(RuntimeBeanEntry root, Map<RuntimeBeanEntry, InstanceConfig> cache) {
        HashMap children = Maps.newHashMap();
        for (RuntimeBeanEntry child : root.getChildren()) {
            children.put(child.getJavaNamePrefix(), this.createInstanceRuntime(child, cache));
        }
        return new InstanceRuntime(cache.get(root), children, this.createJmxToYangMap(root.getChildren()));
    }

    private Map<String, String> createJmxToYangMap(List<RuntimeBeanEntry> children) {
        HashMap jmxToYangNamesForChildRbe = Maps.newHashMap();
        for (RuntimeBeanEntry rbe : children) {
            jmxToYangNamesForChildRbe.put(rbe.getJavaNamePrefix(), rbe.getYangName());
        }
        return jmxToYangNamesForChildRbe;
    }

    private static void checkXml(XmlElement xml) {
        xml.checkName("get");
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        if (xml.getChildElements("filter").size() != 0) {
            throw new UnsupportedOperationException("Unsupported option filter for get");
        }
    }

    @Override
    protected String getOperationName() {
        return "get";
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        try {
            Get.checkXml(xml);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing xml", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Unsupported", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_not_supported.name(), "Unsupported option for 'get'");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        Set runtimeBeans = this.configRegistryClient.lookupRuntimeBeans();
        Set<ObjectName> configBeans = Datastore.getInstanceQueryStrategy(Datastore.running, null).queryInstances(this.configRegistryClient);
        Map<String, Map<String, ModuleRuntime>> moduleRuntimes = this.createModuleRuntimes(this.configRegistryClient, this.yangStoreSnapshot.getModuleMXBeanEntryMap());
        Map<String, Map<String, ModuleConfig>> moduleConfigs = EditConfig.transformMbeToModuleConfigs(this.configRegistryClient, this.yangStoreSnapshot.getModuleMXBeanEntryMap());
        Runtime runtime = new Runtime(moduleRuntimes, moduleConfigs);
        ObjectName txOn = this.transactionProvider.getOrCreateTransaction();
        ConfigTransactionClient ta = this.configRegistryClient.getConfigTransactionClient(txOn);
        Element element = runtime.toXml(runtimeBeans, configBeans, document, new ServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta));
        logger.trace("{} operation successful", (Object)"get");
        return element;
    }
}

