/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.AbstractEditConfigStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingInstanceHandlingStrategy
extends AbstractEditConfigStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MissingInstanceHandlingStrategy.class);

    @Override
    void handleMissingInstance(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, String module, String instance, ServiceRegistryWrapper services) {
        ObjectName on = null;
        try {
            on = ta.createModule(module, instance);
            logger.trace("New instance for {} {} created under name {}", new Object[]{module, instance, on});
        }
        catch (InstanceAlreadyExistsException e1) {
            throw new IllegalStateException("Unable to create instance for " + module + " : " + instance);
        }
    }

    @Override
    void executeStrategy(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, ObjectName objectName, ServiceRegistryWrapper services) {
    }
}

