/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.AbstractEditConfigStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeEditConfigStrategy
extends AbstractEditConfigStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MergeEditConfigStrategy.class);
    private final Multimap<String, String> providedServices;

    public MergeEditConfigStrategy() {
        this.providedServices = HashMultimap.create();
    }

    public MergeEditConfigStrategy(Multimap<String, String> providedServices) {
        this.providedServices = providedServices;
    }

    @Override
    void handleMissingInstance(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, String module, String instance, ServiceRegistryWrapper services) {
        throw new IllegalStateException("Unable to handle missing instance, no missing instances should appear at this point, missing: " + module + ":" + instance);
    }

    private void addRefNames(ServiceRegistryWrapper services, Multimap<String, String> providedServices, ConfigTransactionClient ta, ObjectName on) throws InstanceNotFoundException {
        for (Map.Entry namespaceToService : providedServices.entries()) {
            if (services.hasRefName((String)namespaceToService.getKey(), (String)namespaceToService.getValue(), on)) continue;
            String refName = services.getNewDefaultRefName((String)namespaceToService.getKey(), (String)namespaceToService.getValue(), ObjectNameUtil.getFactoryName((ObjectName)on), ObjectNameUtil.getInstanceName((ObjectName)on));
            ta.saveServiceReference(ta.getServiceInterfaceName((String)namespaceToService.getKey(), (String)namespaceToService.getValue()), refName, on);
        }
    }

    @Override
    void executeStrategy(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, ObjectName on, ServiceRegistryWrapper services) {
        try {
            this.addRefNames(services, this.providedServices, ta, on);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Unable to save default ref name for instance " + on, e);
        }
        for (Map.Entry<String, AttributeConfigElement> configAttributeEntry : configuration.entrySet()) {
            try {
                AttributeConfigElement ace = configAttributeEntry.getValue();
                if (!ace.getResolvedValue().isPresent()) {
                    logger.debug("Skipping attribute {} for {}", (Object)configAttributeEntry.getKey(), (Object)on);
                    continue;
                }
                Object value = ace.getResolvedValue().get();
                ta.setAttribute(on, ace.getJmxName(), new Attribute(ace.getJmxName(), value));
                logger.debug("Attribute {} set to {} for {}", new Object[]{configAttributeEntry.getKey(), value, on});
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to set attributes for " + on + ", Error with attribute " + configAttributeEntry.getKey() + ":" + configAttributeEntry.getValue(), e);
            }
        }
    }
}

