/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Set;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.DeleteEditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.MergeEditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.NoneEditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.RemoveEditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.ReplaceEditConfigStrategy;

public enum EditStrategyType {
    merge,
    replace,
    none,
    delete,
    remove;

    private static final Set<EditStrategyType> defaultStrats;

    public static EditStrategyType getDefaultStrategy() {
        return merge;
    }

    public boolean isEnforcing() {
        switch (this) {
            case merge: 
            case none: 
            case remove: 
            case delete: {
                return false;
            }
            case replace: {
                return true;
            }
        }
        throw new IllegalStateException("Default edit strategy can be only of value " + defaultStrats + " but was " + (Object)((Object)this));
    }

    public EditConfigStrategy getFittingStrategy(Multimap<String, String> providedServices) {
        switch (this) {
            case merge: {
                return new MergeEditConfigStrategy(providedServices);
            }
            case replace: {
                return new ReplaceEditConfigStrategy(providedServices);
            }
            case delete: {
                return new DeleteEditConfigStrategy(providedServices);
            }
            case remove: {
                return new RemoveEditConfigStrategy();
            }
            case none: {
                return new NoneEditConfigStrategy();
            }
        }
        throw new UnsupportedOperationException("Unimplemented edit config strategy" + (Object)((Object)this));
    }

    static {
        defaultStrats = EnumSet.of(merge, replace, none);
    }
}

