/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Map;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Config;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Services;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditConfigXmlParser {
    private static final Logger logger = LoggerFactory.getLogger(EditConfigXmlParser.class);
    public static final String EDIT_CONFIG = "edit-config";
    public static final String DEFAULT_OPERATION_KEY = "default-operation";
    static final String ERROR_OPTION_KEY = "error-option";
    static final String DEFAULT_ERROR_OPTION = "stop-on-error";
    static final String TARGET_KEY = "target";
    static final String TEST_OPTION_KEY = "test-option";

    EditConfigExecution fromXml(XmlElement xml, Config cfgMapping, TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient) throws NetconfDocumentedException {
        String errorOptionParsed;
        TestOption testOption;
        EditStrategyType editStrategyType = EditStrategyType.getDefaultStrategy();
        xml.checkName(EDIT_CONFIG);
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        XmlElement targetElement = xml.getOnlyChildElementWithSameNamespace(TARGET_KEY);
        XmlElement targetChildNode = targetElement.getOnlyChildElementWithSameNamespace();
        String datastoreValue = targetChildNode.getName();
        Datastore targetDatastore = Datastore.valueOf(datastoreValue);
        logger.debug("Setting {} to '{}'", (Object)TARGET_KEY, (Object)targetDatastore);
        Preconditions.checkArgument((targetDatastore == Datastore.candidate ? 1 : 0) != 0, (String)"Only %s datastore supported for edit config but was: %s", (Object[])new Object[]{Datastore.candidate, targetDatastore});
        Optional testOptionElementOpt = xml.getOnlyChildElementWithSameNamespaceOptionally(TEST_OPTION_KEY);
        if (testOptionElementOpt.isPresent()) {
            String testOptionValue = ((XmlElement)testOptionElementOpt.get()).getTextContent();
            testOption = TestOption.getFromXmlName(testOptionValue);
        } else {
            testOption = TestOption.getDefault();
        }
        logger.debug("Setting {} to '{}'", (Object)TEST_OPTION_KEY, (Object)testOption);
        Optional errorOptionElement = xml.getOnlyChildElementWithSameNamespaceOptionally(ERROR_OPTION_KEY);
        if (errorOptionElement.isPresent() && !(errorOptionParsed = ((XmlElement)errorOptionElement.get()).getTextContent()).equals(DEFAULT_ERROR_OPTION)) {
            throw new UnsupportedOperationException("Only stop-on-error supported for error-option, was " + errorOptionParsed);
        }
        Optional defaultContent = xml.getOnlyChildElementWithSameNamespaceOptionally(DEFAULT_OPERATION_KEY);
        if (defaultContent.isPresent()) {
            String mergeStrategyString = ((XmlElement)defaultContent.get()).getTextContent();
            logger.trace("Setting merge strategy to {}", (Object)mergeStrategyString);
            editStrategyType = EditStrategyType.valueOf(mergeStrategyString);
        }
        XmlElement configElement = xml.getOnlyChildElementWithSameNamespace("config");
        return new EditConfigExecution(cfgMapping, configElement, testOption, editStrategyType);
    }

    @VisibleForTesting
    static class EditConfigExecution {
        private final TestOption testOption;
        private final EditStrategyType defaultEditStrategyType;
        private final Services services;
        private final Config configResolver;
        private final XmlElement configElement;

        EditConfigExecution(Config configResolver, XmlElement configElement, TestOption testOption, EditStrategyType defaultStrategy) {
            Config.checkUnrecognisedChildren(configElement);
            this.configResolver = configResolver;
            this.configElement = configElement;
            this.services = configResolver.fromXmlServices(configElement);
            this.testOption = testOption;
            this.defaultEditStrategyType = defaultStrategy;
        }

        boolean shouldTest() {
            return this.testOption == TestOption.testOnly || this.testOption == TestOption.testThenSet;
        }

        boolean shouldSet() {
            return this.testOption == TestOption.set || this.testOption == TestOption.testThenSet;
        }

        Map<String, Multimap<String, ModuleElementResolved>> getResolvedXmlElements(ServiceReferenceReadableRegistry serviceRegistry) {
            return this.configResolver.fromXmlModulesResolved(this.configElement, this.defaultEditStrategyType, this.getServiceRegistryWrapper(serviceRegistry));
        }

        ServiceRegistryWrapper getServiceRegistryWrapper(ServiceReferenceReadableRegistry serviceRegistry) {
            return new ServiceRegistryWrapper(serviceRegistry);
        }

        Map<String, Multimap<String, ModuleElementDefinition>> getModulesDefinition(ServiceReferenceReadableRegistry serviceRegistry) {
            return this.configResolver.fromXmlModulesMap(this.configElement, this.defaultEditStrategyType, this.getServiceRegistryWrapper(serviceRegistry));
        }

        EditStrategyType getDefaultStrategy() {
            return this.defaultEditStrategyType;
        }

        Services getServices() {
            return this.services;
        }
    }

    @VisibleForTesting
    static enum TestOption {
        testOnly,
        set,
        testThenSet;


        static TestOption getFromXmlName(String testOptionXmlName) {
            switch (testOptionXmlName) {
                case "test-only": {
                    return testOnly;
                }
                case "test-then-set": {
                    return testThenSet;
                }
                case "set": {
                    return set;
                }
            }
            throw new IllegalArgumentException("Unsupported test option " + testOptionXmlName + " supported: " + Arrays.toString((Object[])TestOption.values()));
        }

        public static TestOption getDefault() {
            return testThenSet;
        }
    }
}

