/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Config;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Services;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfigXmlParser;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditConfig
extends AbstractConfigNetconfOperation {
    private static final Logger logger = LoggerFactory.getLogger(EditConfig.class);
    private final YangStoreSnapshot yangStoreSnapshot;
    private final TransactionProvider transactionProvider;
    private EditConfigXmlParser editConfigXmlParser;

    public EditConfig(YangStoreSnapshot yangStoreSnapshot, TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.yangStoreSnapshot = yangStoreSnapshot;
        this.transactionProvider = transactionProvider;
        this.editConfigXmlParser = new EditConfigXmlParser();
    }

    @VisibleForTesting
    Element getResponseInternal(Document document, EditConfigXmlParser.EditConfigExecution editConfigExecution) throws NetconfDocumentedException {
        if (editConfigExecution.shouldTest()) {
            this.executeTests(this.configRegistryClient, editConfigExecution);
        }
        if (editConfigExecution.shouldSet()) {
            this.executeSet(this.configRegistryClient, editConfigExecution);
        }
        logger.trace("Operation {} successful", (Object)"edit-config");
        return document.createElement("ok");
    }

    private void executeSet(ConfigRegistryClient configRegistryClient, EditConfigXmlParser.EditConfigExecution editConfigExecution) throws NetconfDocumentedException {
        try {
            this.set(configRegistryClient, editConfigExecution);
        }
        catch (IllegalStateException | JmxAttributeValidationException | ValidationException e) {
            logger.warn("Set phase for {} failed", (Object)"edit-config", (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), e.getMessage());
            throw new NetconfDocumentedException("Test phase: " + e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        logger.debug("Set phase for {} operation successful", (Object)"edit-config");
    }

    private void executeTests(ConfigRegistryClient configRegistryClient, EditConfigXmlParser.EditConfigExecution editConfigExecution) throws NetconfDocumentedException {
        try {
            this.test(configRegistryClient, editConfigExecution, editConfigExecution.getDefaultStrategy());
        }
        catch (IllegalStateException | JmxAttributeValidationException | ValidationException e) {
            logger.warn("Test phase for {} failed", (Object)"edit-config", (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), e.getMessage());
            throw new NetconfDocumentedException("Test phase: " + e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        logger.debug("Test phase for {} operation successful", (Object)"edit-config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(ConfigRegistryClient configRegistryClient, EditConfigXmlParser.EditConfigExecution execution, EditStrategyType editStrategyType) {
        ObjectName taON = this.transactionProvider.getTestTransaction();
        try {
            if (editStrategyType == EditStrategyType.replace) {
                this.transactionProvider.wipeTestTransaction(taON);
            }
            ConfigTransactionClient ta = configRegistryClient.getConfigTransactionClient(taON);
            this.handleMisssingInstancesOnTransaction(ta, execution);
            this.setServicesOnTransaction(ta, execution);
            this.setOnTransaction(ta, execution);
            this.transactionProvider.validateTestTransaction(taON);
        }
        finally {
            this.transactionProvider.abortTestTransaction(taON);
        }
    }

    private void set(ConfigRegistryClient configRegistryClient, EditConfigXmlParser.EditConfigExecution editConfigExecution) {
        ObjectName taON = this.transactionProvider.getOrCreateTransaction();
        if (editConfigExecution.getDefaultStrategy() == EditStrategyType.replace) {
            this.transactionProvider.wipeTransaction();
        }
        ConfigTransactionClient ta = configRegistryClient.getConfigTransactionClient(taON);
        this.handleMisssingInstancesOnTransaction(ta, editConfigExecution);
        this.setServicesOnTransaction(ta, editConfigExecution);
        this.setOnTransaction(ta, editConfigExecution);
    }

    private void setServicesOnTransaction(ConfigTransactionClient ta, EditConfigXmlParser.EditConfigExecution execution) {
        Services services = execution.getServices();
        Map<String, Map<String, Map<String, Services.ServiceInstance>>> namespaceToServiceNameToRefNameToInstance = services.getNamespaceToServiceNameToRefNameToInstance();
        for (String serviceNamespace : namespaceToServiceNameToRefNameToInstance.keySet()) {
            for (String serviceName : namespaceToServiceNameToRefNameToInstance.get(serviceNamespace).keySet()) {
                String qnameOfService = this.getQname(ta, serviceNamespace, serviceName);
                Map<String, Services.ServiceInstance> refNameToInstance = namespaceToServiceNameToRefNameToInstance.get(serviceNamespace).get(serviceName);
                for (String refName : refNameToInstance.keySet()) {
                    ObjectName on = refNameToInstance.get(refName).getObjectName(ta.getTransactionName());
                    try {
                        ObjectName saved = ta.saveServiceReference(qnameOfService, refName, on);
                        logger.debug("Saving service {} with on {} under name {} with service on {}", new Object[]{qnameOfService, on, refName, saved});
                    }
                    catch (InstanceNotFoundException e) {
                        throw new IllegalStateException("Unable to save ref name " + refName + " for instance " + on, e);
                    }
                }
            }
        }
    }

    private String getQname(ConfigTransactionClient ta, String namespace, String serviceName) {
        return ta.getServiceInterfaceName(namespace, serviceName);
    }

    private void setOnTransaction(ConfigTransactionClient ta, EditConfigXmlParser.EditConfigExecution execution) {
        for (Multimap<String, ModuleElementResolved> modulesToResolved : execution.getResolvedXmlElements((ServiceReferenceReadableRegistry)ta).values()) {
            for (Map.Entry moduleToResolved : modulesToResolved.entries()) {
                String moduleName = (String)moduleToResolved.getKey();
                ModuleElementResolved moduleElementResolved = (ModuleElementResolved)moduleToResolved.getValue();
                String instanceName = moduleElementResolved.getInstanceName();
                InstanceConfigElementResolved ice = moduleElementResolved.getInstanceConfigElementResolved();
                EditConfigStrategy strategy = ice.getEditStrategy();
                strategy.executeConfiguration(moduleName, instanceName, ice.getConfiguration(), ta, execution.getServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta));
            }
        }
    }

    private void handleMisssingInstancesOnTransaction(ConfigTransactionClient ta, EditConfigXmlParser.EditConfigExecution execution) {
        for (Multimap<String, ModuleElementDefinition> modulesToResolved : execution.getModulesDefinition((ServiceReferenceReadableRegistry)ta).values()) {
            for (Map.Entry moduleToResolved : modulesToResolved.entries()) {
                String moduleName = (String)moduleToResolved.getKey();
                ModuleElementDefinition moduleElementDefinition = (ModuleElementDefinition)moduleToResolved.getValue();
                EditConfigStrategy strategy = moduleElementDefinition.getEditStrategy();
                strategy.executeConfiguration(moduleName, moduleElementDefinition.getInstanceName(), null, ta, execution.getServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta));
            }
        }
    }

    public static Config getConfigMapping(ConfigRegistryClient configRegistryClient, YangStoreSnapshot yangStoreSnapshot) {
        Map<String, Map<String, ModuleConfig>> factories = EditConfig.transformMbeToModuleConfigs(configRegistryClient, yangStoreSnapshot.getModuleMXBeanEntryMap());
        Map<String, Map<Date, IdentityMapping>> identitiesMap = EditConfig.transformIdentities(yangStoreSnapshot.getModules());
        return new Config(factories, identitiesMap);
    }

    private static Map<String, Map<Date, IdentityMapping>> transformIdentities(Set<Module> modules) {
        HashMap mappedIds = Maps.newHashMap();
        for (Module module : modules) {
            Date revision;
            String namespace = module.getNamespace().toString();
            Map revisionsByNamespace = (Map)mappedIds.get(namespace);
            if (revisionsByNamespace == null) {
                revisionsByNamespace = Maps.newHashMap();
                mappedIds.put(namespace, revisionsByNamespace);
            }
            Preconditions.checkState((!revisionsByNamespace.containsKey(revision = module.getRevision()) ? 1 : 0) != 0, (String)"Duplicate revision %s for namespace %s", (Object[])new Object[]{revision, namespace});
            IdentityMapping identityMapping = (IdentityMapping)revisionsByNamespace.get(revision);
            if (identityMapping == null) {
                identityMapping = new IdentityMapping();
                revisionsByNamespace.put(revision, identityMapping);
            }
            for (IdentitySchemaNode identitySchemaNode : module.getIdentities()) {
                identityMapping.addIdSchemaNode(identitySchemaNode);
            }
        }
        return mappedIds;
    }

    public static Map<String, Map<String, ModuleConfig>> transformMbeToModuleConfigs(ConfigRegistryClient configRegistryClient, Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        HashMap namespaceToModuleNameToModuleConfig = Maps.newHashMap();
        for (String namespace : mBeanEntries.keySet()) {
            for (Map.Entry<String, ModuleMXBeanEntry> moduleNameToMbe : mBeanEntries.get(namespace).entrySet()) {
                String moduleName = moduleNameToMbe.getKey();
                ModuleMXBeanEntry moduleMXBeanEntry = moduleNameToMbe.getValue();
                ModuleConfig moduleConfig = new ModuleConfig(moduleName, new InstanceConfig(configRegistryClient, moduleMXBeanEntry.getAttributes()), moduleMXBeanEntry.getProvidedServices().values());
                Map moduleNameToModuleConfig = (Map)namespaceToModuleNameToModuleConfig.get(namespace);
                if (moduleNameToModuleConfig == null) {
                    moduleNameToModuleConfig = Maps.newHashMap();
                    namespaceToModuleNameToModuleConfig.put(namespace, moduleNameToModuleConfig);
                }
                moduleNameToModuleConfig.put(moduleName, moduleConfig);
            }
        }
        return namespaceToModuleNameToModuleConfig;
    }

    @Override
    protected String getOperationName() {
        return "edit-config";
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        EditConfigXmlParser.EditConfigExecution editConfigExecution;
        Config cfg = EditConfig.getConfigMapping(this.configRegistryClient, this.yangStoreSnapshot);
        try {
            editConfigExecution = this.editConfigXmlParser.fromXml(xml, cfg, this.transactionProvider, this.configRegistryClient);
        }
        catch (IllegalStateException e) {
            logger.warn("Error parsing xml", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.missing_attribute.name(), "Error parsing xml: " + e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.missing_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing xml", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Unsupported", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_not_supported.name(), "Unsupported option for 'edit-config'");
            throw new NetconfDocumentedException(e.getMessage(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_not_supported, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        return this.getResponseInternal(document, editConfigExecution);
    }

    public static class IdentityMapping {
        private final Map<String, IdentitySchemaNode> identityNameToSchemaNode = Maps.newHashMap();

        IdentityMapping() {
        }

        void addIdSchemaNode(IdentitySchemaNode node) {
            String name = node.getQName().getLocalName();
            Preconditions.checkState((!this.identityNameToSchemaNode.containsKey(name) ? 1 : 0) != 0);
            this.identityNameToSchemaNode.put(name, node);
        }

        public boolean containsIdName(String idName) {
            return this.identityNameToSchemaNode.containsKey(idName);
        }

        public IdentitySchemaNode getIdentitySchemaNode(String idName) {
            Preconditions.checkState((boolean)this.identityNameToSchemaNode.containsKey(idName), (String)"No identity under name %s", (Object[])new Object[]{idName});
            return this.identityNameToSchemaNode.get(idName);
        }
    }
}

