/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.AbstractEditConfigStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteEditConfigStrategy
extends AbstractEditConfigStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DeleteEditConfigStrategy.class);
    private final Multimap<String, String> providedServices;

    public DeleteEditConfigStrategy() {
        this.providedServices = HashMultimap.create();
    }

    public DeleteEditConfigStrategy(Multimap<String, String> providedServices) {
        this.providedServices = providedServices;
    }

    @Override
    void handleMissingInstance(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, String module, String instance, ServiceRegistryWrapper services) {
        throw new IllegalStateException("Unable to delete " + module + ":" + instance + " , ServiceInstance not found");
    }

    @Override
    void executeStrategy(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, ObjectName on, ServiceRegistryWrapper services) {
        try {
            ta.destroyModule(on);
            logger.debug("ServiceInstance {} deleted successfully", (Object)on);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Unable to delete " + on, e);
        }
    }
}

