/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Validate
extends AbstractConfigNetconfOperation {
    public static final String VALIDATE = "validate";
    private static final Logger logger = LoggerFactory.getLogger(Validate.class);
    private final TransactionProvider transactionProvider;

    public Validate(TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    private void checkXml(XmlElement xml) {
        xml.checkName(VALIDATE);
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        XmlElement sourceElement = xml.getOnlyChildElement("source", "urn:ietf:params:xml:ns:netconf:base:1.0");
        XmlElement sourceChildNode = sourceElement.getOnlyChildElement();
        sourceChildNode.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        String datastoreValue = sourceChildNode.getName();
        Datastore sourceDatastore = Datastore.valueOf(datastoreValue);
        Preconditions.checkState((sourceDatastore == Datastore.candidate ? 1 : 0) != 0, (Object)("Only " + (Object)((Object)Datastore.candidate) + " is supported as source for " + VALIDATE + " but was " + datastoreValue));
    }

    @Override
    protected String getOperationName() {
        return VALIDATE;
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        try {
            this.checkXml(xml);
        }
        catch (IllegalStateException e) {
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.missing_attribute, (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.missing_attribute.name(), "Missing value of datastore attribute");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.missing_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.bad_attribute, (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        try {
            this.transactionProvider.validateTransaction();
        }
        catch (ValidationException e) {
            logger.warn("Validation failed", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), "Validation failed");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)((Object)e), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (IllegalStateException e) {
            logger.warn("Validation failed", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), "Datastore is not present. Use 'get-config' or 'edit-config' before triggering 'operations' operation");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        logger.trace("Datastore {} validated successfully", (Object)Datastore.candidate);
        return document.createElement("ok");
    }
}

