/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations;

import java.util.HashMap;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscardChanges
extends AbstractConfigNetconfOperation {
    public static final String DISCARD = "discard-changes";
    private static final Logger logger = LoggerFactory.getLogger(DiscardChanges.class);
    private final TransactionProvider transactionProvider;

    public DiscardChanges(TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    private static void fromXml(XmlElement xml) {
        xml.checkName(DISCARD);
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    @Override
    protected String getOperationName() {
        return DISCARD;
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        try {
            DiscardChanges.fromXml(xml);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.bad_attribute, (Object)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        try {
            this.transactionProvider.abortTransaction();
        }
        catch (IllegalStateException e) {
            logger.warn("Abort failed: ", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), "Operation failed. Use 'get-config' or 'edit-config' before triggering 'discard-changes' operation");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        logger.trace("Changes discarded successfully from datastore {}", (Object)Datastore.candidate);
        return document.createElement("ok");
    }
}

