/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.operations;

import java.util.HashMap;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.AbstractConfigNetconfOperation;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.Datastore;
import org.opendaylight.controller.netconf.confignetconfconnector.transactions.TransactionProvider;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Commit
extends AbstractConfigNetconfOperation {
    private static final Logger logger = LoggerFactory.getLogger(Commit.class);
    private final TransactionProvider transactionProvider;

    public Commit(TransactionProvider transactionProvider, ConfigRegistryClient configRegistryClient, String netconfSessionIdForReporting) {
        super(configRegistryClient, netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    private static void checkXml(XmlElement xml) {
        xml.checkName("commit");
        xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    @Override
    protected String getOperationName() {
        return "commit";
    }

    @Override
    protected Element handle(Document document, XmlElement xml) throws NetconfDocumentedException {
        CommitStatus status;
        Commit.checkXml(xml);
        try {
            status = this.transactionProvider.commitTransaction();
        }
        catch (IllegalStateException e) {
            logger.warn("Commit failed: ", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.name(), "Operation failed. Use 'get-config' or 'edit-config' before triggering 'commit' operation");
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (NetconfDocumentedException e) {
            throw new NetconfDocumentedException("Unable to retrieve config snapshot after commit for persister, details: " + e.getMessage(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, e.getErrorInfo());
        }
        logger.trace("Datastore {} committed successfully: {}", (Object)Datastore.candidate, (Object)status);
        return document.createElement("ok");
    }
}

