/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Config;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime.ModuleRuntime;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Runtime {
    private final Map<String, Map<String, ModuleRuntime>> moduleRuntimes;
    private final Map<String, Map<String, ModuleConfig>> moduleConfigs;

    public Runtime(Map<String, Map<String, ModuleRuntime>> moduleRuntimes, Map<String, Map<String, ModuleConfig>> moduleConfigs) {
        this.moduleRuntimes = moduleRuntimes;
        this.moduleConfigs = moduleConfigs;
    }

    private Map<String, Multimap<String, ObjectName>> mapInstancesToModules(Set<ObjectName> instancesToMap) {
        HashMap retVal = Maps.newHashMap();
        for (ObjectName objectName : instancesToMap) {
            String moduleName = ObjectNameUtil.getFactoryName((ObjectName)objectName);
            Multimap multimap = (Multimap)retVal.get(moduleName);
            if (multimap == null) {
                multimap = HashMultimap.create();
                retVal.put(moduleName, multimap);
            }
            String instanceName = ObjectNameUtil.getInstanceName((ObjectName)objectName);
            multimap.put((Object)instanceName, (Object)objectName);
        }
        return retVal;
    }

    public Element toXml(Set<ObjectName> instancesToMap, Set<ObjectName> configBeans, Document document, ServiceRegistryWrapper serviceRegistry) {
        Element root = document.createElement("data");
        Element modulesElement = document.createElement("modules");
        XmlUtil.addNamespaceAttr((Element)modulesElement, (String)"urn:opendaylight:params:xml:ns:yang:controller:config");
        root.appendChild(modulesElement);
        Map<String, Multimap<String, ObjectName>> moduleToRuntimeInstance = this.mapInstancesToModules(instancesToMap);
        Map<String, Map<String, Collection<ObjectName>>> moduleToConfigInstance = Config.getMappedInstances(configBeans, this.moduleConfigs);
        for (String localNamespace : this.moduleConfigs.keySet()) {
            Map<String, Collection<ObjectName>> instanceToMbe = moduleToConfigInstance.get(localNamespace);
            for (String moduleName : this.moduleConfigs.get(localNamespace).keySet()) {
                Multimap<String, ObjectName> instanceToRbe = moduleToRuntimeInstance.get(moduleName);
                for (ObjectName instanceON : instanceToMbe.get(moduleName)) {
                    Element runtimeXml;
                    String instanceName = ObjectNameUtil.getInstanceName((ObjectName)instanceON);
                    ModuleConfig moduleConfig = this.moduleConfigs.get(localNamespace).get(moduleName);
                    if (instanceToRbe == null || !instanceToRbe.containsKey((Object)instanceName)) {
                        runtimeXml = moduleConfig.toXml(instanceON, serviceRegistry, document, localNamespace);
                    } else {
                        ModuleRuntime moduleRuntime = this.moduleRuntimes.get(localNamespace).get(moduleName);
                        runtimeXml = moduleRuntime.toXml(localNamespace, instanceToRbe.get((Object)instanceName), document, moduleConfig, instanceON, serviceRegistry);
                    }
                    modulesElement.appendChild(runtimeXml);
                }
            }
        }
        return root;
    }

    private ObjectName findInstance(Collection<ObjectName> objectNames, String instanceName) {
        for (ObjectName objectName : objectNames) {
            String name = ObjectNameUtil.getInstanceName((ObjectName)objectName);
            if (!name.equals(instanceName)) continue;
            return objectName;
        }
        throw new UnsupportedOperationException("Unable to find config bean instance under name " + instanceName + " among " + objectNames);
    }
}

