/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.management.ObjectName;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.runtime.InstanceRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleRuntime {
    private final String moduleName;
    private final InstanceRuntime instanceRuntime;

    public ModuleRuntime(String moduleName, InstanceRuntime instanceRuntime) {
        this.moduleName = moduleName;
        this.instanceRuntime = instanceRuntime;
    }

    public InstanceRuntime getMbeanMapping() {
        return this.instanceRuntime;
    }

    private ObjectName findRoot(Collection<ObjectName> runtimeBeanOns) {
        for (ObjectName objectName : runtimeBeanOns) {
            if (objectName.getKeyPropertyList().size() != 3) continue;
            return objectName;
        }
        throw new IllegalStateException("Root runtime bean not found among " + runtimeBeanOns);
    }

    public Element toXml(String namespace, Collection<ObjectName> runtimeBeanOns, Document document, ModuleConfig moduleConfig, ObjectName configBeanON, ServiceRegistryWrapper serviceTracker) {
        Element moduleElement = moduleConfig.toXml(configBeanON, serviceTracker, document, namespace);
        ObjectName rootName = this.findRoot(runtimeBeanOns);
        HashSet childrenRuntimeBeans = Sets.newHashSet(runtimeBeanOns);
        childrenRuntimeBeans.remove(rootName);
        this.instanceRuntime.toXml(rootName, childrenRuntimeBeans, document, moduleElement, namespace);
        return moduleElement;
    }
}

