/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc.InstanceRuntimeRpc;

public final class ModuleRpcs {
    Map<String, String> yangToJavaNames = Maps.newHashMap();
    Map<String, Map<String, InstanceRuntimeRpc>> rpcMapping = Maps.newHashMap();

    public void addNameMapping(RuntimeBeanEntry runtimeEntry) {
        String yangName = runtimeEntry.getYangName();
        Preconditions.checkState((!this.yangToJavaNames.containsKey(yangName) ? 1 : 0) != 0, (String)"RuntimeBean %s found twice in same namespace", (Object[])new Object[]{yangName});
        this.yangToJavaNames.put(yangName, runtimeEntry.getJavaNamePrefix());
    }

    public void addRpc(RuntimeBeanEntry runtimeEntry, RuntimeBeanEntry.Rpc rpc) {
        String yangName = runtimeEntry.getYangName();
        HashMap map = this.rpcMapping.get(yangName);
        if (map == null) {
            map = Maps.newHashMap();
            this.rpcMapping.put(yangName, map);
        }
        Preconditions.checkState((!map.containsKey(rpc.getYangName()) ? 1 : 0) != 0, (String)"Rpc %s for runtime bean %s added twice", (Object[])new Object[]{rpc.getYangName(), yangName});
        map.put(rpc.getYangName(), new InstanceRuntimeRpc(rpc));
    }

    public String getRbeJavaName(String yangName) {
        String javaName = this.yangToJavaNames.get(yangName);
        Preconditions.checkState((javaName != null ? 1 : 0) != 0, (String)"No runtime bean entry found under yang name %s, available yang names %s", (Object[])new Object[]{yangName, this.yangToJavaNames.keySet()});
        return javaName;
    }

    public InstanceRuntimeRpc getRpc(String rbeName, String rpcName) {
        Map<String, InstanceRuntimeRpc> rpcs = this.rpcMapping.get(rbeName);
        Preconditions.checkState((rpcs != null ? 1 : 0) != 0, (String)"No rpcs found for runtime bean %s", (Object[])new Object[]{rbeName});
        InstanceRuntimeRpc rpc = rpcs.get(rpcName);
        Preconditions.checkState((rpc != null ? 1 : 0) != 0, (String)"No rpc found for runtime bean %s with name %s", (Object[])new Object[]{rbeName, rpcName});
        return rpc;
    }
}

