/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.rpc;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeReadingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.ObjectXmlReader;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.ObjectResolver;
import org.opendaylight.controller.netconf.util.xml.XmlElement;

public final class InstanceRuntimeRpc {
    private final Map<String, AttributeIfc> yangToAttrConfig;
    private final RuntimeBeanEntry.Rpc rpc;

    public InstanceRuntimeRpc(RuntimeBeanEntry.Rpc rpc) {
        this.yangToAttrConfig = this.map(rpc.getParameters());
        this.rpc = rpc;
    }

    private Map<String, AttributeIfc> map(List<JavaAttribute> parameters) {
        HashMap mapped = Maps.newHashMap();
        for (JavaAttribute javaAttribute : parameters) {
            mapped.put(javaAttribute.getAttributeYangName(), javaAttribute);
        }
        return mapped;
    }

    private void resolveConfiguration(Map<String, AttributeConfigElement> mappedConfig) {
        Map<String, AttributeResolvingStrategy<?, OpenType<?>>> resolvingStrategies = new ObjectResolver(null).prepareResolving(this.yangToAttrConfig);
        for (Map.Entry<String, AttributeConfigElement> configDefEntry : mappedConfig.entrySet()) {
            try {
                AttributeResolvingStrategy<?, ? extends OpenType<?>> attributeResolvingStrategy = resolvingStrategies.get(configDefEntry.getKey());
                configDefEntry.getValue().resolveValue(attributeResolvingStrategy, configDefEntry.getKey());
                configDefEntry.getValue().setJmxName(this.yangToAttrConfig.get(configDefEntry.getKey()).getUpperCaseCammelCase());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to resolve value " + configDefEntry.getValue() + " to attribute " + configDefEntry.getKey(), e);
            }
        }
    }

    public Map<String, AttributeConfigElement> fromXml(XmlElement configRootNode) {
        HashMap retVal = Maps.newHashMap();
        Map<String, AttributeReadingStrategy> strats = new ObjectXmlReader().prepareReading(this.yangToAttrConfig, Collections.emptyMap());
        for (Map.Entry<String, AttributeReadingStrategy> readStratEntry : strats.entrySet()) {
            List configNodes = configRootNode.getChildElements(readStratEntry.getKey());
            AttributeConfigElement readElement = readStratEntry.getValue().readElement(configNodes);
            retVal.put(readStratEntry.getKey(), readElement);
        }
        this.resolveConfiguration(retVal);
        return retVal;
    }

    public String getName() {
        return this.rpc.getName();
    }

    public AttributeIfc getReturnType() {
        return this.rpc.getReturnType();
    }
}

