/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.ObjectNameAttributeReadingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Services {
    private static final Logger logger = LoggerFactory.getLogger(Services.class);
    private static final String PROVIDER_KEY = "provider";
    private static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String SERVICE_KEY = "service";
    private final Map<String, Map<String, Map<String, ServiceInstance>>> namespaceToServiceNameToRefNameToInstance = Maps.newHashMap();

    public Map<String, Map<String, Map<String, ServiceInstance>>> getNamespaceToServiceNameToRefNameToInstance() {
        return this.namespaceToServiceNameToRefNameToInstance;
    }

    private static Services resolveServices(Map<String, Map<String, Map<String, String>>> mappedServices) {
        Services tracker = new Services();
        for (Map.Entry<String, Map<String, Map<String, String>>> namespaceEntry : mappedServices.entrySet()) {
            String namespace = namespaceEntry.getKey();
            for (Map.Entry<String, Map<String, String>> serviceEntry : namespaceEntry.getValue().entrySet()) {
                String serviceName = serviceEntry.getKey();
                for (Map.Entry<String, String> refEntry : serviceEntry.getValue().entrySet()) {
                    Map refNameToInstance;
                    HashMap namespaceToServices = tracker.namespaceToServiceNameToRefNameToInstance.get(namespace);
                    if (namespaceToServices == null) {
                        namespaceToServices = Maps.newHashMap();
                        tracker.namespaceToServiceNameToRefNameToInstance.put(namespace, namespaceToServices);
                    }
                    if ((refNameToInstance = (Map)namespaceToServices.get(serviceName)) == null) {
                        refNameToInstance = Maps.newHashMap();
                        namespaceToServices.put(serviceName, refNameToInstance);
                    }
                    String refName = refEntry.getKey();
                    ServiceInstance serviceInstance = ServiceInstance.fromString(refEntry.getValue());
                    refNameToInstance.put(refName, serviceInstance);
                }
            }
        }
        return tracker;
    }

    public static Services fromXml(XmlElement xml) {
        HashMap retVal = Maps.newHashMap();
        List services = xml.getChildElements(SERVICE_KEY);
        xml.checkUnrecognisedElements(services, new XmlElement[0]);
        for (XmlElement service : services) {
            XmlElement typeElement = service.getOnlyChildElement(TYPE_KEY);
            Map.Entry prefixNamespace = typeElement.findNamespaceOfTextContent();
            Preconditions.checkState((prefixNamespace.getKey() != null && !((String)prefixNamespace.getKey()).equals("") ? 1 : 0) != 0, (Object)"Type attribute was not prefixed");
            Map namespaceToServices = (Map)retVal.get(prefixNamespace.getValue());
            if (namespaceToServices == null) {
                namespaceToServices = Maps.newHashMap();
                retVal.put(prefixNamespace.getValue(), namespaceToServices);
            }
            String serviceName = ObjectNameAttributeReadingStrategy.checkPrefixAndExtractServiceName(typeElement, prefixNamespace);
            HashMap innerMap = Maps.newHashMap();
            namespaceToServices.put(serviceName, innerMap);
            List instances = service.getChildElements("instance");
            service.checkUnrecognisedElements(instances, new XmlElement[]{typeElement});
            for (XmlElement instance : instances) {
                XmlElement nameElement = instance.getOnlyChildElement(NAME_KEY);
                String refName = nameElement.getTextContent();
                XmlElement providerElement = instance.getOnlyChildElement(PROVIDER_KEY);
                String providerName = providerElement.getTextContent();
                instance.checkUnrecognisedElements(new XmlElement[]{nameElement, providerElement});
                innerMap.put(refName, providerName);
            }
        }
        return Services.resolveServices(retVal);
    }

    public static Element toXml(ServiceRegistryWrapper serviceRegistryWrapper, Document document) {
        Element root = document.createElement("services");
        XmlUtil.addNamespaceAttr((Element)root, (String)"urn:opendaylight:params:xml:ns:yang:controller:config");
        Map<String, Map<String, Map<String, String>>> mappedServices = serviceRegistryWrapper.getMappedServices();
        for (String namespace : mappedServices.keySet()) {
            for (Map.Entry<String, Map<String, String>> serviceEntry : mappedServices.get(namespace).entrySet()) {
                Element serviceElement = document.createElement(SERVICE_KEY);
                root.appendChild(serviceElement);
                Element typeElement = XmlUtil.createPrefixedTextElement((Document)document, (String)TYPE_KEY, (String)"prefix", (String)serviceEntry.getKey());
                XmlUtil.addPrefixedNamespaceAttr((Element)typeElement, (String)"prefix", (String)namespace);
                serviceElement.appendChild(typeElement);
                for (Map.Entry<String, String> instanceEntry : serviceEntry.getValue().entrySet()) {
                    Element instanceElement = document.createElement("instance");
                    serviceElement.appendChild(instanceElement);
                    Element nameElement = XmlUtil.createTextElement((Document)document, (String)NAME_KEY, (String)instanceEntry.getKey());
                    instanceElement.appendChild(nameElement);
                    Element providerElement = XmlUtil.createTextElement((Document)document, (String)PROVIDER_KEY, (String)instanceEntry.getValue());
                    instanceElement.appendChild(providerElement);
                }
            }
        }
        return root;
    }

    public static final class ServiceInstance {
        private final String moduleName;
        private final String instanceName;
        private String serviceName;
        private static final String blueprint = "/modules/module[type='%s'][name='%s']";
        private static final String blueprintRDeprecated = "/config/modules/module\\[name='%s'\\]/instance\\[name='%s'\\]";
        private static final String blueprintR = "/modules/module\\[type='%s'\\]\\[name='%s'\\]";
        private static final Pattern pDeprecated = Pattern.compile(String.format("/config/modules/module\\[name='%s'\\]/instance\\[name='%s'\\]", "(.+)", "(.+)"));
        private static final Pattern p = Pattern.compile(String.format("/modules/module\\[type='%s'\\]\\[name='%s'\\]", "(.+)", "(.+)"));

        public ServiceInstance(String moduleName, String instanceName) {
            this.moduleName = moduleName;
            this.instanceName = instanceName;
        }

        public static ServiceInstance fromString(String instanceId) {
            Matcher matcher = p.matcher(instanceId = instanceId.trim());
            if (!matcher.matches()) {
                matcher = pDeprecated.matcher(instanceId);
            }
            Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Unexpected format for provider, expected " + p.toString() + " or " + pDeprecated.toString() + " but was " + instanceId));
            String factoryName = matcher.group(1);
            String instanceName = matcher.group(2);
            return new ServiceInstance(factoryName, instanceName);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String toString() {
            return String.format(blueprint, this.moduleName, this.instanceName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
            result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceInstance other = (ServiceInstance)obj;
            if (this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName)) {
                return false;
            }
            return !(this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName));
        }

        public ObjectName getObjectName(String transactionName) {
            return ObjectNameUtil.createTransactionModuleON((String)transactionName, (String)this.moduleName, (String)this.instanceName);
        }

        public static ServiceInstance fromObjectName(ObjectName on) {
            return new ServiceInstance(ObjectNameUtil.getFactoryName((ObjectName)on), ObjectNameUtil.getInstanceName((ObjectName)on));
        }
    }
}

