/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Services;
import org.opendaylight.yangtools.yang.common.QName;

public class ServiceRegistryWrapper {
    private ServiceReferenceReadableRegistry configServiceRefRegistry;
    private long suffix = 1L;

    public ServiceRegistryWrapper(ServiceReferenceReadableRegistry configServiceRefRegistry) {
        this.configServiceRefRegistry = configServiceRefRegistry;
    }

    public boolean hasRefName(String namespace, String serviceName, ObjectName on) {
        String qname = this.configServiceRefRegistry.getServiceInterfaceName(namespace, serviceName);
        Map forQName = (Map)this.configServiceRefRegistry.getServiceMapping().get(qname);
        if (forQName == null) {
            return false;
        }
        return forQName.values().contains(on);
    }

    public ObjectName getByServiceAndRefName(String namespace, String serviceName, String refName) {
        Map<String, Map<String, String>> serviceNameToRefNameToInstance = this.getMappedServices().get(namespace);
        Preconditions.checkArgument((serviceNameToRefNameToInstance != null ? 1 : 0) != 0, (Object)("No serviceInstances mapped to " + namespace));
        Map<String, String> refNameToInstance = serviceNameToRefNameToInstance.get(serviceName);
        Preconditions.checkArgument((refNameToInstance != null ? 1 : 0) != 0, (Object)("No serviceInstances mapped to " + serviceName + " , " + serviceNameToRefNameToInstance.keySet()));
        String instanceId = refNameToInstance.get(refName);
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)("No serviceInstances mapped to " + serviceName + ":" + refName + ", " + serviceNameToRefNameToInstance.keySet()));
        Services.ServiceInstance serviceInstance = Services.ServiceInstance.fromString(instanceId);
        Preconditions.checkArgument((serviceInstance != null ? 1 : 0) != 0, (Object)("No serviceInstance mapped to " + refName + " under service name " + serviceName + " , " + refNameToInstance.keySet()));
        String qNameOfService = this.configServiceRefRegistry.getServiceInterfaceName(namespace, serviceName);
        try {
            return this.configServiceRefRegistry.getServiceReference(qNameOfService, refName);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("No serviceInstance mapped to " + refName + " under service name " + serviceName + " , " + refNameToInstance.keySet(), e);
        }
    }

    public Map<String, Map<String, Map<String, String>>> getMappedServices() {
        HashMap retVal = Maps.newHashMap();
        Map serviceMapping = this.configServiceRefRegistry.getServiceMapping();
        for (String serviceQName : serviceMapping.keySet()) {
            for (String refName : ((Map)serviceMapping.get(serviceQName)).keySet()) {
                String localName;
                Map refsToSis;
                ObjectName on = (ObjectName)((Map)serviceMapping.get(serviceQName)).get(refName);
                Services.ServiceInstance si = Services.ServiceInstance.fromObjectName(on);
                QName qname = QName.create((String)serviceQName);
                String namespace = qname.getNamespace().toString();
                Map serviceToRefs = (Map)retVal.get(namespace);
                if (serviceToRefs == null) {
                    serviceToRefs = Maps.newHashMap();
                    retVal.put(namespace, serviceToRefs);
                }
                if ((refsToSis = (Map)serviceToRefs.get(localName = qname.getLocalName())) == null) {
                    refsToSis = Maps.newHashMap();
                    serviceToRefs.put(localName, refsToSis);
                }
                Preconditions.checkState((!refsToSis.containsKey(refName) ? 1 : 0) != 0, (String)"Duplicate reference name %s for service %s:%s, now for instance %s", (Object[])new Object[]{refName, namespace, localName, on});
                refsToSis.put(refName, si.toString());
            }
        }
        return retVal;
    }

    @VisibleForTesting
    public String getNewDefaultRefName(String namespace, String serviceName, String moduleName, String instanceName) {
        String refName = "ref_" + instanceName;
        Map<String, Map<String, String>> serviceNameToRefNameToInstance = this.getMappedServices().get(namespace);
        Map<Object, Object> refNameToInstance = serviceNameToRefNameToInstance == null || !serviceNameToRefNameToInstance.containsKey(serviceName) ? Collections.emptyMap() : serviceNameToRefNameToInstance.get(serviceName);
        Set<String> refNamesAsSet = this.toSet(refNameToInstance.keySet());
        if (refNamesAsSet.contains(refName)) {
            refName = this.findAvailableRefName(refName, refNamesAsSet);
        }
        return refName;
    }

    private Set<String> toSet(Collection<String> values) {
        HashSet refNamesAsSet = Sets.newHashSet();
        for (String refName : values) {
            boolean resultAdd = refNamesAsSet.add(refName);
            Preconditions.checkState((boolean)resultAdd, (String)"Error occurred building services element, reference name {} was present twice", (Object[])new Object[]{refName});
        }
        return refNamesAsSet;
    }

    private String findAvailableRefName(String refName, Set<String> refNamesAsSet) {
        String intitialRefName = refName;
        while (refNamesAsSet.contains(refName = intitialRefName + "_" + this.suffix++)) {
        }
        return refName;
    }
}

