/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.MissingInstanceHandlingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.NoneEditConfigStrategy;

public class ModuleElementDefinition {
    public static final NoneEditConfigStrategy NONE_EDIT_CONFIG_STRATEGY = new NoneEditConfigStrategy();
    public static final MissingInstanceHandlingStrategy MISSING_INSTANCE_HANDLING_STRATEGY = new MissingInstanceHandlingStrategy();
    private final String instanceName;
    private final EditStrategyType editStrategy;

    public ModuleElementDefinition(String instanceName, String currentStrategy, EditStrategyType defaultStrategy) {
        this.instanceName = instanceName;
        this.editStrategy = currentStrategy == null || currentStrategy.isEmpty() ? defaultStrategy : InstanceConfigElementResolved.parseStrategy(currentStrategy, defaultStrategy);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public EditStrategyType getEditStrategyType() {
        return this.editStrategy;
    }

    public EditConfigStrategy getEditStrategy() {
        switch (this.editStrategy) {
            case delete: 
            case remove: 
            case none: {
                return NONE_EDIT_CONFIG_STRATEGY;
            }
        }
        return MISSING_INSTANCE_HANDLING_STRATEGY;
    }
}

