/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleConfig {
    private final String moduleName;
    private final InstanceConfig instanceConfig;
    private final Multimap<String, String> providedServices;

    public ModuleConfig(String moduleName, InstanceConfig mbeanMapping, Collection<QName> providedServices) {
        this.moduleName = moduleName;
        this.instanceConfig = mbeanMapping;
        this.providedServices = this.mapServices(providedServices);
    }

    private Multimap<String, String> mapServices(Collection<QName> providedServices) {
        HashMultimap mapped = HashMultimap.create();
        for (QName providedService : providedServices) {
            String key = providedService.getNamespace().toString();
            mapped.put((Object)key, (Object)providedService.getLocalName());
        }
        return mapped;
    }

    public InstanceConfig getMbeanMapping() {
        return this.instanceConfig;
    }

    public Multimap<String, String> getProvidedServices() {
        return this.providedServices;
    }

    public Element toXml(ObjectName instanceON, ServiceRegistryWrapper depTracker, Document document, String namespace) {
        Element root = document.createElement("module");
        String prefix = this.getPrefix(namespace);
        Element typeElement = XmlUtil.createPrefixedTextElement((Document)document, (String)"type", (String)prefix, (String)this.moduleName);
        XmlUtil.addPrefixedNamespaceAttr((Element)typeElement, (String)prefix, (String)namespace);
        root.appendChild(typeElement);
        Element nameElement = XmlUtil.createTextElement((Document)document, (String)"name", (String)ObjectNameUtil.getInstanceName((ObjectName)instanceON));
        root.appendChild(nameElement);
        root = this.instanceConfig.toXml(instanceON, depTracker, namespace, document, root);
        return root;
    }

    private String getPrefix(String namespace) {
        return "prefix";
    }

    public ModuleElementResolved fromXml(XmlElement moduleElement, ServiceRegistryWrapper depTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy, Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap) {
        InstanceConfigElementResolved ice = this.instanceConfig.fromXml(moduleElement, depTracker, moduleNamespace, defaultStrategy, this.providedServices, identityMap);
        return new ModuleElementResolved(instanceName, ice);
    }
}

