/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfigStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;

public class InstanceConfigElementResolved {
    private final EditStrategyType editStrategy;
    private final Map<String, AttributeConfigElement> configuration;
    private final Multimap<String, String> providedServices;

    public InstanceConfigElementResolved(String currentStrategy, Map<String, AttributeConfigElement> configuration, EditStrategyType defaultStrategy, Multimap<String, String> providedServices) {
        EditStrategyType valueOf;
        this.editStrategy = valueOf = InstanceConfigElementResolved.parseStrategy(currentStrategy, defaultStrategy);
        this.configuration = configuration;
        this.providedServices = providedServices;
    }

    public InstanceConfigElementResolved(Map<String, AttributeConfigElement> configuration, EditStrategyType defaultStrategy, Multimap<String, String> providedServices) {
        this.editStrategy = defaultStrategy;
        this.configuration = configuration;
        this.providedServices = providedServices;
    }

    static EditStrategyType parseStrategy(String currentStrategy, EditStrategyType defaultStrategy) {
        EditStrategyType parsedStrategy = EditStrategyType.valueOf(currentStrategy);
        if (defaultStrategy.isEnforcing()) {
            Preconditions.checkArgument((parsedStrategy == defaultStrategy ? 1 : 0) != 0, (Object)("With " + (Object)((Object)defaultStrategy) + " as " + "default-operation" + " operations on module elements are not permitted since the default option is restrictive"));
        }
        return parsedStrategy;
    }

    public EditConfigStrategy getEditStrategy() {
        return this.editStrategy.getFittingStrategy(this.providedServices);
    }

    public Map<String, AttributeConfigElement> getConfiguration() {
        return this.configuration;
    }
}

