/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeReadingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.ObjectXmlReader;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.ObjectMapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.ObjectResolver;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.ObjectXmlWriter;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class InstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(InstanceConfig.class);
    private final Map<String, AttributeIfc> yangToAttrConfig;
    private final Map<String, AttributeIfc> jmxToAttrConfig;
    private final ConfigRegistryClient configRegistryClient;

    public InstanceConfig(ConfigRegistryClient configRegistryClient, Map<String, AttributeIfc> yangNamesToAttributes) {
        this.yangToAttrConfig = yangNamesToAttributes;
        this.jmxToAttrConfig = InstanceConfig.reverseMap(yangNamesToAttributes);
        this.configRegistryClient = configRegistryClient;
    }

    private Map<String, Object> getMappedConfiguration(ObjectName on, ServiceRegistryWrapper depTracker) {
        Map<String, AttributeMappingStrategy<?, OpenType<?>>> mappingStrategies = new ObjectMapper(depTracker).prepareMapping(this.jmxToAttrConfig);
        HashMap toXml = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> configDefEntry : this.jmxToAttrConfig.entrySet()) {
            if (configDefEntry.getValue() instanceof RuntimeBeanEntry) continue;
            Object value = this.configRegistryClient.getAttributeCurrentValue(on, configDefEntry.getKey());
            try {
                AttributeMappingStrategy<?, OpenType<?>> attributeMappingStrategy = mappingStrategies.get(configDefEntry.getKey());
                Optional<?> a = attributeMappingStrategy.mapAttribute(value);
                if (!a.isPresent()) continue;
                toXml.put(configDefEntry.getValue().getAttributeYangName(), a.get());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to map value " + value + " to attribute " + configDefEntry.getKey(), e);
            }
        }
        return toXml;
    }

    public Element toXml(ObjectName on, ServiceRegistryWrapper depTracker, String namespace, Document document, Element rootElement) {
        Element cfgElement = rootElement;
        Map<String, AttributeWritingStrategy> strats = new ObjectXmlWriter().prepareWriting(this.yangToAttrConfig, document);
        Map<String, Object> mappedConfig = this.getMappedConfiguration(on, depTracker);
        for (Map.Entry<String, Object> mappingEntry : mappedConfig.entrySet()) {
            try {
                strats.get(mappingEntry.getKey()).writeElement(cfgElement, namespace, mappingEntry.getValue());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to write value " + mappingEntry.getValue() + " for attribute " + mappingEntry.getValue(), e);
            }
        }
        return cfgElement;
    }

    private void resolveConfiguration(InstanceConfigElementResolved mappedConfig, ServiceRegistryWrapper depTracker) {
        Map<String, AttributeResolvingStrategy<?, OpenType<?>>> resolvingStrategies = new ObjectResolver(depTracker).prepareResolving(this.yangToAttrConfig);
        for (Map.Entry<String, AttributeConfigElement> configDefEntry : mappedConfig.getConfiguration().entrySet()) {
            AttributeConfigElement value = configDefEntry.getValue();
            String attributeName = configDefEntry.getKey();
            try {
                AttributeResolvingStrategy<?, ? extends OpenType<?>> attributeResolvingStrategy = resolvingStrategies.get(attributeName);
                logger.trace("Trying to set value {} of attribute {} with {}", new Object[]{value, attributeName, attributeResolvingStrategy});
                value.resolveValue(attributeResolvingStrategy, attributeName);
                value.setJmxName(this.yangToAttrConfig.get(attributeName).getUpperCaseCammelCase());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to resolve value " + value + " to attribute " + attributeName, e);
            }
        }
    }

    public InstanceConfigElementResolved fromXml(XmlElement moduleElement, ServiceRegistryWrapper services, String moduleNamespace, EditStrategyType defaultStrategy, Multimap<String, String> providedServices, Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap) {
        HashMap retVal = Maps.newHashMap();
        Map<String, AttributeReadingStrategy> strats = new ObjectXmlReader().prepareReading(this.yangToAttrConfig, identityMap);
        ArrayList recognisedChildren = Lists.newArrayList();
        XmlElement type = moduleElement.getOnlyChildElementWithSameNamespace("type");
        XmlElement name = moduleElement.getOnlyChildElementWithSameNamespace("name");
        ArrayList typeAndName = Lists.newArrayList((Object[])new XmlElement[]{type, name});
        for (Map.Entry<String, AttributeReadingStrategy> readStratEntry : strats.entrySet()) {
            List<XmlElement> configNodes = this.getConfigNodes(moduleElement, moduleNamespace, readStratEntry.getKey(), recognisedChildren, typeAndName);
            AttributeConfigElement readElement = readStratEntry.getValue().readElement(configNodes);
            retVal.put(readStratEntry.getKey(), readElement);
        }
        recognisedChildren.addAll(typeAndName);
        moduleElement.checkUnrecognisedElements((List)recognisedChildren, new XmlElement[0]);
        String perInstanceEditStrategy = moduleElement.getAttribute("operation", "urn:ietf:params:xml:ns:netconf:base:1.0");
        InstanceConfigElementResolved instanceConfigElementResolved = perInstanceEditStrategy.equals("") ? new InstanceConfigElementResolved(retVal, defaultStrategy, providedServices) : new InstanceConfigElementResolved(perInstanceEditStrategy, retVal, defaultStrategy, providedServices);
        this.resolveConfiguration(instanceConfigElementResolved, services);
        return instanceConfigElementResolved;
    }

    private List<XmlElement> getConfigNodes(XmlElement moduleElement, String moduleNamespace, String name, List<XmlElement> recognisedChildren, List<XmlElement> typeAndName) {
        List foundConfigNodes = moduleElement.getChildElementsWithinNamespace(name, moduleNamespace);
        if (foundConfigNodes.isEmpty()) {
            logger.debug("No config nodes {}:{} found in {}", new Object[]{moduleNamespace, name, moduleElement});
            logger.debug("Trying lookup of config nodes without specified namespace");
            foundConfigNodes = moduleElement.getChildElementsWithinNamespace(name, "urn:opendaylight:params:xml:ns:yang:controller:config");
            foundConfigNodes.removeAll(typeAndName);
            logger.debug("Found {} config nodes {} without specified namespace in {}", new Object[]{foundConfigNodes.size(), name, moduleElement});
        } else {
            List foundWithoutNamespaceNodes = moduleElement.getChildElementsWithinNamespace(name, "urn:opendaylight:params:xml:ns:yang:controller:config");
            foundWithoutNamespaceNodes.removeAll(typeAndName);
            Preconditions.checkState((boolean)foundWithoutNamespaceNodes.isEmpty(), (String)"Element %s present multiple times with different namespaces: %s, %s", (Object[])new Object[]{name, foundConfigNodes, foundWithoutNamespaceNodes});
        }
        recognisedChildren.addAll(foundConfigNodes);
        return foundConfigNodes;
    }

    private static Map<String, AttributeIfc> reverseMap(Map<String, AttributeIfc> yangNameToAttr) {
        HashMap reversednameToAtr = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> entry : yangNameToAttr.entrySet()) {
            reversednameToAtr.put(entry.getValue().getUpperCaseCammelCase(), entry.getValue());
        }
        return reversednameToAtr;
    }
}

