/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.config.Services;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditStrategyType;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Config {
    private final Logger logger = LoggerFactory.getLogger(Config.class);
    private final Map<String, Map<String, ModuleConfig>> moduleConfigs;
    private final Map<String, ModuleConfig> moduleNamesToConfigs;
    private final Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap;

    public Config(Map<String, Map<String, ModuleConfig>> moduleConfigs) {
        this(moduleConfigs, Collections.emptyMap());
    }

    public Config(Map<String, Map<String, ModuleConfig>> moduleConfigs, Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap) {
        this.moduleConfigs = moduleConfigs;
        HashMap<String, ModuleConfig> moduleNamesToConfigs = new HashMap<String, ModuleConfig>();
        for (Map.Entry<String, Map<String, ModuleConfig>> entry : moduleConfigs.entrySet()) {
            moduleNamesToConfigs.putAll(entry.getValue());
        }
        this.moduleNamesToConfigs = Collections.unmodifiableMap(moduleNamesToConfigs);
        this.identityMap = identityMap;
    }

    public static Map<String, Map<String, Collection<ObjectName>>> getMappedInstances(Set<ObjectName> instancesToMap, Map<String, Map<String, ModuleConfig>> configs) {
        Multimap<String, ObjectName> moduleToInstances = Config.mapInstancesToModules(instancesToMap);
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (String namespace : configs.keySet()) {
            HashMap innerRetVal = Maps.newHashMap();
            for (Map.Entry<String, ModuleConfig> mbeEntry : configs.get(namespace).entrySet()) {
                String moduleName = mbeEntry.getKey();
                Collection instances = moduleToInstances.get((Object)moduleName);
                if (instances == null) continue;
                innerRetVal.put(moduleName, instances);
            }
            retVal.put(namespace, innerRetVal);
        }
        return retVal;
    }

    private static Multimap<String, ObjectName> mapInstancesToModules(Set<ObjectName> instancesToMap) {
        HashMultimap retVal = HashMultimap.create();
        for (ObjectName objectName : instancesToMap) {
            String factoryName = ObjectNameUtil.getFactoryName((ObjectName)objectName);
            retVal.put((Object)factoryName, (Object)objectName);
        }
        return retVal;
    }

    public Element toXml(Set<ObjectName> instancesToMap, Optional<String> maybeNamespace, Document document, Element dataElement, ServiceRegistryWrapper serviceTracker) {
        Map<String, Map<String, Collection<ObjectName>>> moduleToInstances = Config.getMappedInstances(instancesToMap, this.moduleConfigs);
        Element root = dataElement;
        if (maybeNamespace.isPresent()) {
            XmlUtil.addNamespaceAttr((Element)root, (String)((String)maybeNamespace.get()));
        }
        Element modulesElement = document.createElement("modules");
        XmlUtil.addNamespaceAttr((Element)modulesElement, (String)"urn:opendaylight:params:xml:ns:yang:controller:config");
        root.appendChild(modulesElement);
        for (String moduleNamespace : moduleToInstances.keySet()) {
            for (Map.Entry<String, Collection<ObjectName>> moduleMappingEntry : moduleToInstances.get(moduleNamespace).entrySet()) {
                ModuleConfig mapping = this.moduleConfigs.get(moduleNamespace).get(moduleMappingEntry.getKey());
                if (moduleMappingEntry.getValue().isEmpty()) continue;
                for (ObjectName objectName : moduleMappingEntry.getValue()) {
                    modulesElement.appendChild(mapping.toXml(objectName, serviceTracker, document, moduleNamespace));
                }
            }
        }
        root.appendChild(Services.toXml(serviceTracker, document));
        return root;
    }

    public Map<String, Multimap<String, ModuleElementResolved>> fromXmlModulesResolved(XmlElement xml, EditStrategyType defaultEditStrategyType, ServiceRegistryWrapper serviceTracker) {
        Optional<XmlElement> modulesElement = Config.getModulesElement(xml);
        List<XmlElement> moduleElements = this.getModulesElementList(modulesElement);
        HashMap retVal = Maps.newHashMap();
        for (XmlElement moduleElement : moduleElements) {
            ResolvingStrategy<ModuleElementResolved> resolvingStrategy = new ResolvingStrategy<ModuleElementResolved>(){

                @Override
                public ModuleElementResolved resolveElement(ModuleConfig moduleMapping, XmlElement moduleElement, ServiceRegistryWrapper serviceTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy) {
                    return moduleMapping.fromXml(moduleElement, serviceTracker, instanceName, moduleNamespace, defaultStrategy, Config.this.identityMap);
                }
            };
            this.resolveModule(retVal, serviceTracker, moduleElement, defaultEditStrategyType, resolvingStrategy);
        }
        return retVal;
    }

    public Map<String, Multimap<String, ModuleElementDefinition>> fromXmlModulesMap(XmlElement xml, EditStrategyType defaultEditStrategyType, ServiceRegistryWrapper serviceTracker) {
        Optional<XmlElement> modulesElement = Config.getModulesElement(xml);
        List<XmlElement> moduleElements = this.getModulesElementList(modulesElement);
        HashMap retVal = Maps.newHashMap();
        for (XmlElement moduleElement : moduleElements) {
            ResolvingStrategy<ModuleElementDefinition> resolvingStrategy = new ResolvingStrategy<ModuleElementDefinition>(){

                @Override
                public ModuleElementDefinition resolveElement(ModuleConfig moduleMapping, XmlElement moduleElement, ServiceRegistryWrapper serviceTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy) {
                    String perInstanceEditStrategy = moduleElement.getAttribute("operation", "urn:ietf:params:xml:ns:netconf:base:1.0");
                    return new ModuleElementDefinition(instanceName, perInstanceEditStrategy, defaultStrategy);
                }
            };
            this.resolveModule(retVal, serviceTracker, moduleElement, defaultEditStrategyType, resolvingStrategy);
        }
        return retVal;
    }

    private static Optional<XmlElement> getModulesElement(XmlElement xml) {
        return xml.getOnlyChildElementOptionally("modules", "urn:opendaylight:params:xml:ns:yang:controller:config");
    }

    private List<XmlElement> getModulesElementList(Optional<XmlElement> modulesElement) {
        List moduleElements;
        if (modulesElement.isPresent()) {
            moduleElements = ((XmlElement)modulesElement.get()).getChildElementsWithSameNamespace("module");
            ((XmlElement)modulesElement.get()).checkUnrecognisedElements(moduleElements, new XmlElement[0]);
        } else {
            moduleElements = Lists.newArrayList();
        }
        return moduleElements;
    }

    private <T> void resolveModule(Map<String, Multimap<String, T>> retVal, ServiceRegistryWrapper serviceTracker, XmlElement moduleElement, EditStrategyType defaultStrategy, ResolvingStrategy<T> resolvingStrategy) {
        XmlElement typeElement = moduleElement.getOnlyChildElementWithSameNamespace("type");
        Map.Entry prefixToNamespace = typeElement.findNamespaceOfTextContent();
        String moduleNamespace = (String)prefixToNamespace.getValue();
        XmlElement nameElement = moduleElement.getOnlyChildElementWithSameNamespace("name");
        String instanceName = nameElement.getTextContent();
        String factoryNameWithPrefix = typeElement.getTextContent();
        String prefixOrEmptyString = (String)prefixToNamespace.getKey();
        String factoryName = this.getFactoryName(factoryNameWithPrefix, prefixOrEmptyString);
        ModuleConfig moduleMapping = this.getModuleMapping(moduleNamespace, instanceName, factoryName);
        HashMultimap innerMap = retVal.get(moduleNamespace);
        if (innerMap == null) {
            innerMap = HashMultimap.create();
            retVal.put(moduleNamespace, (Multimap<String, T>)innerMap);
        }
        T resolvedElement = resolvingStrategy.resolveElement(moduleMapping, moduleElement, serviceTracker, instanceName, moduleNamespace, defaultStrategy);
        innerMap.put((Object)factoryName, resolvedElement);
    }

    public Services fromXmlServices(XmlElement xml) {
        Optional<XmlElement> servicesElement = Config.getServicesElement(xml);
        Services services = servicesElement.isPresent() ? Services.fromXml((XmlElement)servicesElement.get()) : new Services();
        return services;
    }

    private static Optional<XmlElement> getServicesElement(XmlElement xml) {
        return xml.getOnlyChildElementOptionally("services", "urn:opendaylight:params:xml:ns:yang:controller:config");
    }

    public static void checkUnrecognisedChildren(XmlElement parent) {
        Optional<XmlElement> servicesOpt = Config.getServicesElement(parent);
        Optional<XmlElement> modulesOpt = Config.getModulesElement(parent);
        ArrayList recognised = Lists.newArrayList();
        if (servicesOpt.isPresent()) {
            recognised.add(servicesOpt.get());
        }
        if (modulesOpt.isPresent()) {
            recognised.add(modulesOpt.get());
        }
        parent.checkUnrecognisedElements((List)recognised, new XmlElement[0]);
    }

    private String getFactoryName(String factoryNameWithPrefix, String prefixOrEmptyString) {
        Preconditions.checkState((boolean)factoryNameWithPrefix.startsWith(prefixOrEmptyString), (Object)String.format("Internal error: text content '%s' of type node does not start with prefix '%s'", factoryNameWithPrefix, prefixOrEmptyString));
        int factoryNameAfterPrefixIndex = prefixOrEmptyString.isEmpty() ? 0 : prefixOrEmptyString.length() + 1;
        return factoryNameWithPrefix.substring(factoryNameAfterPrefixIndex);
    }

    private ModuleConfig getModuleMapping(String moduleNamespace, String instanceName, String factoryName) {
        Map<String, ModuleConfig> mappingsFromNamespace = this.moduleConfigs.get(moduleNamespace);
        Preconditions.checkNotNull(mappingsFromNamespace, (String)"Namespace %s, defined in: module %s of type %s not found, available namespaces: %s", (Object[])new Object[]{moduleNamespace, instanceName, factoryName, this.moduleConfigs.keySet()});
        ModuleConfig moduleMapping = mappingsFromNamespace.get(factoryName);
        Preconditions.checkState((moduleMapping != null ? 1 : 0) != 0, (Object)("Cannot find mapping for module type " + factoryName));
        return moduleMapping;
    }

    private static interface ResolvingStrategy<T> {
        public T resolveElement(ModuleConfig var1, XmlElement var2, ServiceRegistryWrapper var3, String var4, String var5, EditStrategyType var6);
    }
}

