/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleIdentityRefAttributeWritingStrategy
extends SimpleAttributeWritingStrategy {
    private static final char QNAME_SEPARATOR = ':';
    private static final String PREFIX = "prefix";

    public SimpleIdentityRefAttributeWritingStrategy(Document document, String key) {
        super(document, key);
    }

    @Override
    protected Object preprocess(Object value) {
        Util.checkType(value, Map.class);
        Preconditions.checkArgument((((Map)value).size() == 1 ? 1 : 0) != 0, (String)"Unexpected number of values in %s, expected 1", (Object[])new Object[]{value});
        Object stringValue = ((Map)value).values().iterator().next();
        Util.checkType(stringValue, String.class);
        return stringValue;
    }

    @Override
    protected Element createElement(Document doc, String key, String value) {
        QName qName = QName.create((String)value);
        String identity = qName.getLocalName();
        Element element = XmlUtil.createPrefixedTextElement((Document)doc, (String)key, (String)PREFIX, (String)identity);
        String identityNamespace = qName.getNamespace().toString();
        XmlUtil.addPrefixedNamespaceAttr((Element)element, (String)PREFIX, (String)identityNamespace);
        return element;
    }
}

