/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.AttributeIfcSwitchStatement;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.ArrayAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.CompositeAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.ObjectNameAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleBinaryAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleCompositeAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleIdentityRefAttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.SimpleUnionAttributeWritingStrategy;
import org.w3c.dom.Document;

public class ObjectXmlWriter
extends AttributeIfcSwitchStatement<AttributeWritingStrategy> {
    private Document document;
    private String key;

    public Map<String, AttributeWritingStrategy> prepareWriting(Map<String, AttributeIfc> yangToAttrConfig, Document document) {
        HashMap preparedWriting = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> mappedAttributeEntry : yangToAttrConfig.entrySet()) {
            String key = mappedAttributeEntry.getKey();
            AttributeIfc value = mappedAttributeEntry.getValue();
            AttributeWritingStrategy strat = this.prepareWritingStrategy(key, value, document);
            preparedWriting.put(key, strat);
        }
        return preparedWriting;
    }

    public AttributeWritingStrategy prepareWritingStrategy(String key, AttributeIfc expectedAttr, Document document) {
        Preconditions.checkNotNull((Object)expectedAttr, (String)"Mbean attributes mismatch, unable to find expected attribute for %s", (Object[])new Object[]{key});
        this.document = document;
        this.key = key;
        return (AttributeWritingStrategy)this.switchAttribute(expectedAttr);
    }

    @Override
    protected AttributeWritingStrategy caseJavaBinaryAttribute(OpenType<?> openType) {
        return new SimpleBinaryAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseJavaSimpleAttribute(SimpleType<?> openType) {
        return new SimpleAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseJavaArrayAttribute(ArrayType<?> openType) {
        SimpleAttributeWritingStrategy innerStrategy = new SimpleAttributeWritingStrategy(this.document, this.key);
        return new ArrayAttributeWritingStrategy(innerStrategy);
    }

    @Override
    protected AttributeWritingStrategy caseJavaIdentityRefAttribute(OpenType<?> openType) {
        return new SimpleIdentityRefAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseJavaCompositeAttribute(CompositeType openType) {
        return new SimpleCompositeAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseJavaUnionAttribute(OpenType<?> openType) {
        return new SimpleUnionAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseDependencyAttribute(SimpleType<?> openType) {
        return new ObjectNameAttributeWritingStrategy(this.document, this.key);
    }

    @Override
    protected AttributeWritingStrategy caseTOAttribute(CompositeType openType) {
        Preconditions.checkState((boolean)(this.lastAttribute instanceof TOAttribute));
        HashMap innerStrats = Maps.newHashMap();
        String currentKey = this.key;
        for (Map.Entry innerAttrEntry : ((TOAttribute)this.lastAttribute).getYangPropertiesToTypesMap().entrySet()) {
            AttributeWritingStrategy innerStrategy = this.prepareWritingStrategy((String)innerAttrEntry.getKey(), (AttributeIfc)innerAttrEntry.getValue(), this.document);
            innerStrats.put(innerAttrEntry.getKey(), innerStrategy);
        }
        return new CompositeAttributeWritingStrategy(this.document, currentKey, innerStrats);
    }

    @Override
    protected AttributeWritingStrategy caseListAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.lastAttribute instanceof ListAttribute));
        AttributeIfc innerAttribute = ((ListAttribute)this.lastAttribute).getInnerAttribute();
        AttributeWritingStrategy innerStrategy = this.prepareWritingStrategy(this.key, innerAttribute, this.document);
        return new ArrayAttributeWritingStrategy(innerStrategy);
    }

    @Override
    protected AttributeWritingStrategy caseListDependeciesAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.lastAttribute instanceof ListDependenciesAttribute));
        Object innerStrategy = this.caseDependencyAttribute((SimpleType)SimpleType.OBJECTNAME);
        return new ArrayAttributeWritingStrategy((AttributeWritingStrategy)innerStrategy);
    }
}

