/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml;

import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.ObjectNameAttributeMappingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectNameAttributeWritingStrategy
implements AttributeWritingStrategy {
    private final Document document;
    private final String key;

    public ObjectNameAttributeWritingStrategy(Document document, String key) {
        this.document = document;
        this.key = key;
    }

    @Override
    public void writeElement(Element parentElement, String namespace, Object value) {
        Util.checkType(value, ObjectNameAttributeMappingStrategy.MappedDependency.class);
        Element innerNode = this.document.createElement(this.key);
        XmlUtil.addNamespaceAttr((Element)innerNode, (String)namespace);
        String moduleName = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getServiceName();
        String refName = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getRefName();
        String namespaceForType = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getNamespace();
        Element typeElement = XmlUtil.createPrefixedTextElement((Document)this.document, (String)"type", (String)"prefix", (String)moduleName);
        XmlUtil.addPrefixedNamespaceAttr((Element)typeElement, (String)"prefix", (String)namespaceForType);
        innerNode.appendChild(typeElement);
        Element nameElement = XmlUtil.createTextElement((Document)this.document, (String)"name", (String)refName);
        innerNode.appendChild(nameElement);
        parentElement.appendChild(innerNode);
    }
}

