/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml;

import java.util.Map;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompositeAttributeWritingStrategy
implements AttributeWritingStrategy {
    protected final String key;
    protected final Document document;
    protected final Map<String, AttributeWritingStrategy> innerStrats;

    public CompositeAttributeWritingStrategy(Document document, String key, Map<String, AttributeWritingStrategy> innerStrats) {
        this.document = document;
        this.key = key;
        this.innerStrats = innerStrats;
    }

    @Override
    public void writeElement(Element parentElement, String namespace, Object value) {
        Util.checkType(value, Map.class);
        Element innerNode = this.document.createElement(this.key);
        XmlUtil.addNamespaceAttr((Element)innerNode, (String)namespace);
        Map map = (Map)value;
        for (Map.Entry innerObjectEntry : map.entrySet()) {
            Util.checkType(innerObjectEntry.getKey(), String.class);
            String innerKey = (String)innerObjectEntry.getKey();
            Object innerValue = innerObjectEntry.getValue();
            this.innerStrats.get(innerKey).writeElement(innerNode, namespace, innerValue);
        }
        parentElement.appendChild(innerNode);
    }
}

