/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.AbstractAttributeResolvingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleAttributeResolvingStrategy
extends AbstractAttributeResolvingStrategy<Object, SimpleType<?>> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAttributeResolvingStrategy.class);
    private static final String DEFAULT_RESOLVERS = "default";
    private static final Map<String, Resolver> resolverPlugins = Maps.newHashMap();

    SimpleAttributeResolvingStrategy(SimpleType<?> simpleType) {
        super(simpleType);
    }

    public String toString() {
        return "ResolvedSimpleAttribute [" + ((SimpleType)this.getOpenType()).getClassName() + "]";
    }

    @Override
    public Optional<Object> parseAttribute(String attrName, Object value) {
        Class<?> cls;
        if (value == null) {
            return Optional.absent();
        }
        try {
            cls = Class.forName(((SimpleType)this.getOpenType()).getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate class for " + ((SimpleType)this.getOpenType()).getClassName(), e);
        }
        Util.checkType(value, String.class);
        Resolver prefferedPlugin = resolverPlugins.get(cls.getCanonicalName());
        prefferedPlugin = prefferedPlugin == null ? resolverPlugins.get(DEFAULT_RESOLVERS) : prefferedPlugin;
        Object parsedValue = prefferedPlugin.resolveObject(cls, attrName, (String)value);
        logger.debug("Attribute {} : {} parsed to type {} with value {}", new Object[]{attrName, value, this.getOpenType(), parsedValue});
        return Optional.of((Object)parsedValue);
    }

    static {
        resolverPlugins.put(DEFAULT_RESOLVERS, new DefaultResolver());
        resolverPlugins.put(String.class.getCanonicalName(), new StringResolver());
        resolverPlugins.put(Date.class.getCanonicalName(), new DateResolver());
        resolverPlugins.put(Character.class.getCanonicalName(), new CharResolver());
        resolverPlugins.put(BigInteger.class.getCanonicalName(), new BigIntegerResolver());
        resolverPlugins.put(BigDecimal.class.getCanonicalName(), new BigDecimalResolver());
    }

    static class DateResolver
    extends DefaultResolver {
        DateResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws Exception {
            return Util.readDate(value);
        }
    }

    static class CharResolver
    extends DefaultResolver {
        CharResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws Exception {
            return new Character(value.charAt(0));
        }
    }

    static class BigDecimalResolver
    extends DefaultResolver {
        BigDecimalResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws Exception {
            return new BigDecimal(value);
        }
    }

    static class BigIntegerResolver
    extends DefaultResolver {
        BigIntegerResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws Exception {
            return new BigInteger(value);
        }
    }

    static class StringResolver
    extends DefaultResolver {
        StringResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws Exception {
            return value;
        }
    }

    static class DefaultResolver
    implements Resolver {
        DefaultResolver() {
        }

        @Override
        public Object resolveObject(Class<?> type, String attrName, String value) {
            try {
                Object parsedValue = this.parseObject(type, value);
                return parsedValue;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve attribute " + attrName + " from " + value, e);
            }
        }

        protected Object parseObject(Class<?> type, String value) throws Exception {
            Method method = type.getMethod("valueOf", String.class);
            Object parsedValue = method.invoke(null, value);
            return parsedValue;
        }
    }

    static interface Resolver {
        public Object resolveObject(Class<?> var1, String var2, String var3);
    }
}

