/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.mapping.AbstractAttributeMappingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.util.Util;

public class SimpleAttributeMappingStrategy
extends AbstractAttributeMappingStrategy<String, SimpleType<?>> {
    private static final String DEFAULT_WRITER_PLUGIN = "default";
    private static final Map<String, WriterPlugin> writerPlugins = Maps.newHashMap();

    public SimpleAttributeMappingStrategy(SimpleType<?> openType) {
        super(openType);
    }

    @Override
    public Optional<String> mapAttribute(Object value) {
        if (value == null) {
            return Optional.absent();
        }
        String expectedClass = ((SimpleType)this.getOpenType()).getClassName();
        String realClass = value.getClass().getName();
        Preconditions.checkArgument((boolean)realClass.equals(expectedClass), (Object)("Type mismatch, expected " + expectedClass + " but was " + realClass));
        WriterPlugin prefferedPlugin = writerPlugins.get(value.getClass().getCanonicalName());
        prefferedPlugin = prefferedPlugin == null ? writerPlugins.get(DEFAULT_WRITER_PLUGIN) : prefferedPlugin;
        return Optional.of((Object)prefferedPlugin.writeObject(value));
    }

    static {
        writerPlugins.put(DEFAULT_WRITER_PLUGIN, new DefaultWriterPlugin());
        writerPlugins.put(Date.class.getCanonicalName(), new DatePlugin());
    }

    static class DatePlugin
    implements WriterPlugin {
        DatePlugin() {
        }

        @Override
        public String writeObject(Object value) {
            Preconditions.checkArgument((boolean)(value instanceof Date), (Object)"Attribute must be Date");
            return Util.writeDate((Date)value);
        }
    }

    static class DefaultWriterPlugin
    implements WriterPlugin {
        DefaultWriterPlugin() {
        }

        @Override
        public String writeObject(Object value) {
            return value.toString();
        }
    }

    static interface WriterPlugin {
        public String writeObject(Object var1);
    }
}

