/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.SimpleAttributeReadingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.operations.editconfig.EditConfig;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.yangtools.yang.common.QName;

public class SimpleIdentityRefAttributeReadingStrategy
extends SimpleAttributeReadingStrategy {
    private final String key;
    private final Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap;

    public SimpleIdentityRefAttributeReadingStrategy(String nullableDefault, String key, Map<String, Map<Date, EditConfig.IdentityMapping>> identityMap) {
        super(nullableDefault);
        this.key = key;
        this.identityMap = identityMap;
    }

    @Override
    protected String readElementContent(XmlElement xmlElement) {
        Map.Entry namespaceOfTextContent = xmlElement.findNamespaceOfTextContent();
        String content = xmlElement.getTextContent();
        String prefix = (String)namespaceOfTextContent.getKey() + ":";
        Preconditions.checkArgument((boolean)content.startsWith(prefix), (Object)"Identity ref should be prefixed");
        String localName = content.substring(prefix.length());
        String namespace = (String)namespaceOfTextContent.getValue();
        Date revision = null;
        Map<Date, EditConfig.IdentityMapping> revisions = this.identityMap.get(namespace);
        if (revisions.keySet().size() > 1) {
            for (Date date : revisions.keySet()) {
                if (!revisions.get(date).containsIdName(localName)) continue;
                Preconditions.checkState((revision == null ? 1 : 0) != 0, (String)"Duplicate identity %s, in namespace %s, with revisions: %s, %s detected. Cannot map attribute", (Object[])new Object[]{localName, namespace, revision, date});
                revision = date;
            }
        } else {
            revision = revisions.keySet().iterator().next();
        }
        return QName.create((URI)URI.create(namespace), (Date)revision, (String)localName).toString();
    }

    @Override
    protected Object postprocessParsedValue(String textContent) {
        HashMap map = Maps.newHashMap();
        map.put(this.key, textContent);
        return map;
    }

    @Override
    protected Object postprocessNullableDefault(String nullableDefault) {
        return nullableDefault == null ? null : this.postprocessParsedValue(nullableDefault);
    }
}

