/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AbstractAttributeReadingStrategy;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAttributeReadingStrategy
extends AbstractAttributeReadingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAttributeReadingStrategy.class);

    public SimpleAttributeReadingStrategy(String nullableDefault) {
        super(nullableDefault);
    }

    @Override
    AttributeConfigElement readElementHook(List<XmlElement> configNodes) {
        XmlElement xmlElement = configNodes.get(0);
        Preconditions.checkState((configNodes.size() == 1 ? 1 : 0) != 0, (Object)("This element should be present only once " + xmlElement + " but was " + configNodes.size()));
        String textContent = "";
        try {
            textContent = this.readElementContent(xmlElement);
        }
        catch (IllegalStateException | NullPointerException e) {
            logger.warn("Ignoring exception caused by failure to read text element", (Throwable)e);
        }
        Preconditions.checkNotNull((Object)textContent, (String)"This element should contain text %s", (Object[])new Object[]{xmlElement});
        return AttributeConfigElement.create(this.postprocessNullableDefault(this.getNullableDefault()), this.postprocessParsedValue(textContent));
    }

    protected String readElementContent(XmlElement xmlElement) {
        return xmlElement.getTextContent();
    }

    @Override
    protected Object postprocessNullableDefault(String nullableDefault) {
        return nullableDefault;
    }

    protected Object postprocessParsedValue(String textContent) {
        return textContent;
    }
}

