/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.fromxml;

import com.google.common.base.Optional;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.netconf.confignetconfconnector.mapping.attributes.resolving.AttributeResolvingStrategy;

public class AttributeConfigElement {
    private final Object dafaultValue;
    private final Object value;
    private Optional<?> resolvedValue;
    private Object resolvedDefaultValue;
    private String jmxName;

    public AttributeConfigElement(Object dafaultValue, Object value) {
        this.dafaultValue = dafaultValue;
        this.value = value;
    }

    public void setJmxName(String jmxName) {
        this.jmxName = jmxName;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public void resolveValue(AttributeResolvingStrategy<?, ? extends OpenType<?>> attributeResolvingStrategy, String attrName) {
        this.resolvedValue = attributeResolvingStrategy.parseAttribute(attrName, this.value);
        Optional<?> resolvedDefault = attributeResolvingStrategy.parseAttribute(attrName, this.dafaultValue);
        this.resolvedDefaultValue = resolvedDefault.isPresent() ? resolvedDefault.get() : null;
    }

    public static AttributeConfigElement create(Object nullableDefault, Object value) {
        return new AttributeConfigElement(nullableDefault, value);
    }

    public static AttributeConfigElement createNullValue(Object nullableDefault) {
        return new AttributeConfigElement(nullableDefault, null);
    }

    public Object getValue() {
        return this.value;
    }

    public Optional<?> getResolvedValue() {
        return this.resolvedValue;
    }

    public Object getResolvedDefaultValue() {
        return this.resolvedDefaultValue;
    }

    public String toString() {
        return "AttributeConfigElement [dafaultValue=" + this.dafaultValue + ", value=" + this.value + "]";
    }
}

