/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwarding.staticrouting;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.forwarding.staticrouting.StaticRoute;
import org.opendaylight.controller.sal.utils.GUIField;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;

public class StaticRouteConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String regexSubnet = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])[/](\\d|[12]\\d|3[0-2])$";
    private static final String regexIP = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String regexDatapathID = "^([0-9a-fA-F]{1,2}[:-]){7}[0-9a-fA-F]{1,2}$";
    private static final String regexDatapathIDLong = "^[0-9a-fA-F]{1,16}$";
    private static final String[] prettyFields = new String[]{GUIField.NAME.toString(), GUIField.STATICROUTE.toString(), GUIField.NEXTHOP.toString()};
    private transient String nextHopType;
    private String name;
    private String staticRoute;
    private String nextHop;

    public StaticRouteConfig() {
        this.nextHopType = StaticRoute.NextHopType.IPADDRESS.toString();
    }

    public StaticRouteConfig(String name, String staticRoute, String nextHop) {
        this.name = name;
        this.staticRoute = staticRoute;
        this.nextHop = nextHop;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStaticRoute() {
        return this.staticRoute;
    }

    public void setStaticRoute(String staticRoute) {
        this.staticRoute = staticRoute;
    }

    public String getNextHopType() {
        if (this.nextHopType == null) {
            return StaticRoute.NextHopType.IPADDRESS.toString();
        }
        return this.nextHopType;
    }

    public void setNextHopType(String nextHopType) {
        this.nextHopType = nextHopType;
    }

    public static List<String> getSupportedNextHopTypes() {
        ArrayList<String> s = new ArrayList<String>();
        for (StaticRoute.NextHopType nh : StaticRoute.NextHopType.values()) {
            s.add(nh.toString());
        }
        return s;
    }

    public String getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(String nextHop) {
        this.nextHop = nextHop;
    }

    public Status isValid() {
        if (!this.isValidResourceName(this.name)) {
            return new Status(StatusCode.BADREQUEST, "Invalid Static Route name");
        }
        if (!this.isValidStaticRouteEntry()) {
            return new Status(StatusCode.BADREQUEST, "Invalid Static Route entry. Please use the IPAddress/mask format. Default gateway (0.0.0.0/0) is NOT supported.");
        }
        if (!this.isValidNextHop()) {
            return new Status(StatusCode.BADREQUEST, "Invalid NextHop IP Address configuration. Please use the X.X.X.X format.");
        }
        return new Status(StatusCode.SUCCESS, null);
    }

    private boolean isValidAddress(String address) {
        return address != null && address.matches(regexIP);
    }

    private boolean isValidStaticRouteEntry() {
        return this.staticRoute != null && this.staticRoute.matches(regexSubnet);
    }

    private boolean isValidNextHop() {
        if (this.getNextHopType().equalsIgnoreCase(StaticRoute.NextHopType.IPADDRESS.toString())) {
            return this.isValidNextHopIP();
        }
        if (this.getNextHopType().equalsIgnoreCase(StaticRoute.NextHopType.SWITCHPORT.toString())) {
            return this.isValidSwitchId();
        }
        return false;
    }

    private boolean isValidNextHopIP() {
        return this.isValidAddress(this.nextHop);
    }

    private boolean isValidSwitchId(String switchId) {
        return switchId != null && (switchId.matches(regexDatapathID) || switchId.matches(regexDatapathIDLong));
    }

    private boolean isValidSwitchId() {
        if (this.getNextHopType().equalsIgnoreCase(StaticRoute.NextHopType.SWITCHPORT.toString())) {
            String[] pieces = this.nextHop.split("/");
            if (pieces.length < 2) {
                return false;
            }
            return this.isValidSwitchId(pieces[0]);
        }
        return false;
    }

    public InetAddress getStaticRouteIP() {
        if (!this.isValidStaticRouteEntry()) {
            return null;
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(this.staticRoute.split("/")[0]);
        }
        catch (UnknownHostException e1) {
            return null;
        }
        return ip;
    }

    public Short getStaticRouteMask() {
        Short maskLen = 0;
        if (this.isValidStaticRouteEntry()) {
            String[] s = this.staticRoute.split("/");
            maskLen = s.length == 2 ? Short.valueOf(s[1]) : (short)32;
        }
        return maskLen;
    }

    public InetAddress getNextHopIP() {
        if (this.getNextHopType().equalsIgnoreCase(StaticRoute.NextHopType.IPADDRESS.toString()) && this.isValidNextHopIP()) {
            InetAddress ip = null;
            try {
                ip = InetAddress.getByName(this.nextHop);
            }
            catch (UnknownHostException e1) {
                return null;
            }
            return ip;
        }
        return null;
    }

    public Map<Long, Short> getNextHopSwitchPorts() {
        if (this.getNextHopType().equalsIgnoreCase(StaticRoute.NextHopType.SWITCHPORT.toString())) {
            HashMap<Long, Short> sp = new HashMap<Long, Short>(1);
            String[] pieces = this.nextHop.split("/");
            sp.put(this.getSwitchIDLong(pieces[0]), Short.valueOf(pieces[1]));
            return sp;
        }
        return null;
    }

    private long getSwitchIDLong(String switchId) {
        int radix = 16;
        String switchString = "0";
        if (this.isValidSwitchId(switchId)) {
            switchString = switchId.contains(":") ? switchId.replace(":", "") : (switchId.contains("-") ? switchId.replace("-", "") : switchId);
        }
        return Long.parseLong(switchString, radix);
    }

    public static List<String> getFieldsNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field fld : StaticRouteConfig.class.getDeclaredFields()) {
            fieldList.add(fld.getName());
        }
        for (int i = 0; i < 7; i = (int)((short)(i + 1))) {
            fieldList.remove(0);
        }
        return fieldList;
    }

    public static List<String> getGuiFieldsNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String str : prettyFields) {
            fieldList.add(str);
        }
        return fieldList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nextHop == null ? 0 : this.nextHop.hashCode());
        result = 31 * result + (this.staticRoute == null ? 0 : this.staticRoute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticRouteConfig other = (StaticRouteConfig)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nextHop == null ? other.nextHop != null : !this.nextHop.equals(other.nextHop)) {
            return false;
        }
        return !(this.staticRoute == null ? other.staticRoute != null : !this.staticRoute.equals(other.staticRoute));
    }

    public String toString() {
        return "StaticRouteConfig [name=" + this.name + ", staticRoute=" + this.staticRoute + ", nextHopType=" + this.nextHopType + ", nextHop=" + this.nextHop + "]";
    }
}

