/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwarding.staticrouting;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.opendaylight.controller.forwarding.staticrouting.StaticRouteConfig;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LoggerFactory.getLogger(StaticRoute.class);
    InetAddress networkAddress;
    InetAddress mask;
    NextHopType type;
    InetAddress nextHopAddress;
    Node node;
    NodeConnector port;
    HostNodeConnector host;

    public StaticRoute() {
    }

    public StaticRoute(StaticRouteConfig config) {
        this.networkAddress = config.getStaticRouteIP();
        this.mask = StaticRoute.getV4AddressMaskFromDecimal(config.getStaticRouteMask().shortValue());
        this.type = NextHopType.fromString(config.getNextHopType());
        this.nextHopAddress = config.getNextHopIP();
        Map<Long, Short> switchPort = config.getNextHopSwitchPorts();
        if (switchPort != null && switchPort.size() == 1) {
            this.node = NodeCreator.createOFNode((Long)((Long)switchPort.keySet().toArray()[0]));
            this.port = NodeConnectorCreator.createOFNodeConnector((Short)((Short)switchPort.values().toArray()[0]), (Node)this.node);
        }
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public void setNetworkAddress(InetAddress networkAddress) {
        this.networkAddress = networkAddress;
    }

    public InetAddress getMask() {
        return this.mask;
    }

    public void setMask(InetAddress mask) {
        this.mask = mask;
    }

    public NextHopType getType() {
        return this.type;
    }

    public void setType(NextHopType type) {
        this.type = type;
    }

    public InetAddress getNextHopAddress() {
        return this.nextHopAddress;
    }

    public void setNextHopAddress(InetAddress nextHopAddress) {
        this.nextHopAddress = nextHopAddress;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setPort(NodeConnector port) {
        this.port = port;
    }

    public NodeConnector getPort() {
        return this.port;
    }

    public HostNodeConnector getHost() {
        return this.host;
    }

    public void setHost(HostNodeConnector host) {
        this.host = host;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * result + (this.networkAddress == null ? 0 : this.networkAddress.hashCode());
        result = 31 * result + (this.nextHopAddress == null ? 0 : this.nextHopAddress.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        return "StaticRoute [networkAddress=" + this.networkAddress + ", mask=" + this.mask + ", type=" + this.type.toString() + ", nextHopAddress=" + this.nextHopAddress + ", swid=" + this.node + ", port=" + this.port + ", host=" + this.host + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticRoute other = (StaticRoute)obj;
        if (!this.networkAddress.equals(other.networkAddress)) {
            return false;
        }
        return this.mask.equals(other.mask);
    }

    private static InetAddress getV4AddressMaskFromDecimal(int mask) {
        int netmask = 0;
        for (int i = 0; i < mask; ++i) {
            netmask |= 1 << 31 - i;
        }
        try {
            return InetAddress.getByAddress(BitBufferHelper.toByteArray((Number)netmask));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private void applyV4MaskOnByteBuffer(ByteBuffer bb, ByteBuffer bbMask) {
        for (int i = 0; i < bb.array().length; ++i) {
            bb.put(i, (byte)(bb.get(i) & bbMask.get(i)));
        }
    }

    public InetAddress longestPrefixMatch(InetAddress destNetworkAddress) {
        if (destNetworkAddress instanceof Inet4Address) {
            ByteBuffer bbdest = ByteBuffer.wrap(destNetworkAddress.getAddress());
            ByteBuffer bbself = ByteBuffer.wrap(this.networkAddress.getAddress());
            ByteBuffer bbMask = ByteBuffer.wrap(this.mask.getAddress());
            this.applyV4MaskOnByteBuffer(bbdest, bbMask);
            this.applyV4MaskOnByteBuffer(bbself, bbMask);
            if (bbdest.equals(bbself)) {
                try {
                    return InetAddress.getByAddress(bbself.array());
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return null;
    }

    public int compareTo(StaticRoute s) {
        if (s == null) {
            return 1;
        }
        if (this.networkAddress instanceof Inet6Address || s.getNetworkAddress() instanceof Inet6Address) {
            return 1;
        }
        ByteBuffer bbchallenger = ByteBuffer.wrap(s.getNetworkAddress().getAddress());
        ByteBuffer bbself = ByteBuffer.wrap(this.networkAddress.getAddress());
        ByteBuffer bbChallengerMask = ByteBuffer.wrap(s.getMask().getAddress());
        ByteBuffer bbSelfMask = ByteBuffer.wrap(this.getMask().getAddress());
        this.applyV4MaskOnByteBuffer(bbchallenger, bbChallengerMask);
        this.applyV4MaskOnByteBuffer(bbself, bbSelfMask);
        return bbself.compareTo(bbchallenger);
    }

    public static enum NextHopType implements Serializable
    {
        IPADDRESS("nexthop-ip"),
        SWITCHPORT("nexthop-interface");

        private String name;

        private NextHopType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static NextHopType fromString(String str) {
            if (str == null) {
                return IPADDRESS;
            }
            if (str.equals(IPADDRESS.toString())) {
                return IPADDRESS;
            }
            if (str.equals(SWITCHPORT.toString())) {
                return SWITCHPORT;
            }
            return IPADDRESS;
        }
    }
}

